"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(hub, ctx, rds_db_instance_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deregisters an Amazon RDS instance.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        rds_db_instance_arn(str): The Amazon RDS instance's ARN.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.rds_db_instance.deregister(
                ctx, rds_db_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.rds_db_instance.deregister rds_db_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="deregister_rds_db_instance",
        op_kwargs={"RdsDbInstanceArn": rds_db_instance_arn},
    )


async def describe_all(
    hub, ctx, stack_id: str, rds_db_instance_arns: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes Amazon RDS instances.  Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions. This call accepts only one resource-identifying parameter.

    Args:
        stack_id(str): The ID of the stack with which the instances are registered. The operation returns descriptions of all registered Amazon RDS instances.
        rds_db_instance_arns(List, optional): An array containing the ARNs of the instances to be described. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.rds_db_instance.describe_all(ctx, stack_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.rds_db_instance.describe_all stack_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_rds_db_instances",
        op_kwargs={"StackId": stack_id, "RdsDbInstanceArns": rds_db_instance_arns},
    )


async def register(
    hub, ctx, stack_id: str, rds_db_instance_arn: str, db_user: str, db_password: str
) -> None:
    r"""
    **Autogenerated function**

    Registers an Amazon RDS instance with a stack.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        stack_id(str): The stack ID.
        rds_db_instance_arn(str): The Amazon RDS instance's ARN.
        db_user(str): The database's master user name.
        db_password(str): The database password.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.rds_db_instance.register(
                ctx, stack_id=value, rds_db_instance_arn=value, db_user=value, db_password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.rds_db_instance.register stack_id=value, rds_db_instance_arn=value, db_user=value, db_password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="register_rds_db_instance",
        op_kwargs={
            "StackId": stack_id,
            "RdsDbInstanceArn": rds_db_instance_arn,
            "DbUser": db_user,
            "DbPassword": db_password,
        },
    )


async def update(
    hub, ctx, rds_db_instance_arn: str, db_user: str = None, db_password: str = None
) -> None:
    r"""
    **Autogenerated function**

    Updates an Amazon RDS instance.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        rds_db_instance_arn(str): The Amazon RDS instance's ARN.
        db_user(str, optional): The master user name. Defaults to None.
        db_password(str, optional): The database password. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.rds_db_instance.update(ctx, rds_db_instance_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.rds_db_instance.update rds_db_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="update_rds_db_instance",
        op_kwargs={
            "RdsDbInstanceArn": rds_db_instance_arn,
            "DbUser": db_user,
            "DbPassword": db_password,
        },
    )
