"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Describes a user's SSH information.  Required Permissions: To use this action, an IAM user must have self-management enabled or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.my_user_profile.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.my_user_profile.describe
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="opsworks", operation="describe_my_user_profile", op_kwargs={}
    )


async def update(hub, ctx, ssh_public_key: str = None) -> None:
    r"""
    **Autogenerated function**

    Updates a user's SSH public key.  Required Permissions: To use this action, an IAM user must have self-management enabled or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        ssh_public_key(str, optional): The user's SSH public key. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.my_user_profile.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.my_user_profile.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="update_my_user_profile",
        op_kwargs={"SshPublicKey": ssh_public_key},
    )
