"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"set_": "set"}


async def describe(hub, ctx, layer_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Describes load-based auto scaling configurations for specified layers.  You must specify at least one of the parameters.   Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        layer_ids(List): An array of layer IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.load_based_auto_scaling.describe(ctx, layer_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.load_based_auto_scaling.describe layer_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_load_based_auto_scaling",
        op_kwargs={"LayerIds": layer_ids},
    )


async def set_(
    hub,
    ctx,
    layer_id: str,
    enable: bool = None,
    up_scaling: Dict = None,
    down_scaling: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Specify the load-based auto scaling configuration for a specified layer. For more information, see Managing Load with Time-based and Load-based Instances.  To use load-based auto scaling, you must create a set of load-based auto scaling instances. Load-based auto scaling operates only on the instances from that set, so you must ensure that you have created enough instances to handle the maximum anticipated load.   Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        layer_id(str): The layer ID.
        enable(bool, optional): Enables load-based auto scaling for the layer. Defaults to None.
        up_scaling(Dict, optional): An AutoScalingThresholds object with the upscaling threshold configuration. If the load exceeds these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of instances. Defaults to None.
        down_scaling(Dict, optional): An AutoScalingThresholds object with the downscaling threshold configuration. If the load falls below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number of instances. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.load_based_auto_scaling.set(ctx, layer_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.load_based_auto_scaling.set layer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="set_load_based_auto_scaling",
        op_kwargs={
            "LayerId": layer_id,
            "Enable": enable,
            "UpScaling": up_scaling,
            "DownScaling": down_scaling,
        },
    )
