"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    stack_id: str,
    type_: str,
    name: str,
    shortname: str,
    attributes: Dict = None,
    cloud_watch_logs_configuration: Dict = None,
    custom_instance_profile_arn: str = None,
    custom_json: str = None,
    custom_security_group_ids: List = None,
    packages: List = None,
    volume_configurations: List = None,
    enable_auto_healing: bool = None,
    auto_assign_elastic_ips: bool = None,
    auto_assign_public_ips: bool = None,
    custom_recipes: Dict = None,
    install_updates_on_boot: bool = None,
    use_ebs_optimized_instances: bool = None,
    lifecycle_event_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a layer. For more information, see How to Create a Layer.  You should use CreateLayer for noncustom layer types such as PHP App Server only if the stack does not have an existing layer of that type. A stack can have at most one instance of each noncustom layer; if you attempt to create a second instance, CreateLayer fails. A stack can have an arbitrary number of custom layers, so you can call CreateLayer as many times as you like for that layer type.   Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        stack_id(str): The layer stack ID.
        type_(str): The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of custom layers. Built-in layers are not available in Chef 12 stacks.
        name(str): The layer name, which is used by the console.
        shortname(str): For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters, which are limited to the alphanumeric characters, '-', '_', and '.'. The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the Layer Reference.
        attributes(Dict, optional): One or more user-defined key-value pairs to be added to the stack attributes. To create a cluster layer, set the EcsClusterArn attribute to the cluster's ARN. Defaults to None.
        cloud_watch_logs_configuration(Dict, optional): Specifies CloudWatch Logs configuration options for the layer. For more information, see CloudWatchLogsLogStream. Defaults to None.
        custom_instance_profile_arn(str, optional): The ARN of an IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs, see Using Identifiers. Defaults to None.
        custom_json(str, optional): A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see  Using Custom JSON. This feature is supported as of version 1.7.42 of the AWS CLI. . Defaults to None.
        custom_security_group_ids(List, optional): An array containing the layer custom security group IDs. Defaults to None.
        packages(List, optional): An array of Package objects that describes the layer packages. Defaults to None.
        volume_configurations(List, optional): A VolumeConfigurations object that describes the layer's Amazon EBS volumes. Defaults to None.
        enable_auto_healing(bool, optional): Whether to disable auto healing for the layer. Defaults to None.
        auto_assign_elastic_ips(bool, optional): Whether to automatically assign an Elastic IP address to the layer's instances. For more information, see How to Edit a Layer. Defaults to None.
        auto_assign_public_ips(bool, optional): For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see How to Edit a Layer. Defaults to None.
        custom_recipes(Dict, optional): A LayerCustomRecipes object that specifies the layer custom recipes. Defaults to None.
        install_updates_on_boot(bool, optional): Whether to install operating system and package updates when the instance boots. The default value is true. To control when updates are installed, set this value to false. You must then update your instances manually by using CreateDeployment to run the update_dependencies stack command or by manually running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.   To ensure that your instances have the latest security updates, we strongly recommend using the default value of true. . Defaults to None.
        use_ebs_optimized_instances(bool, optional): Whether to use Amazon EBS-optimized instances. Defaults to None.
        lifecycle_event_configuration(Dict, optional): A LifeCycleEventConfiguration object that you can use to configure the Shutdown event to specify an execution timeout and enable or disable Elastic Load Balancer connection draining. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.layer.create(
                ctx, stack_id=value, type_=value, name=value, shortname=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.layer.create stack_id=value, type_=value, name=value, shortname=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="create_layer",
        op_kwargs={
            "StackId": stack_id,
            "Type": type_,
            "Name": name,
            "Shortname": shortname,
            "Attributes": attributes,
            "CloudWatchLogsConfiguration": cloud_watch_logs_configuration,
            "CustomInstanceProfileArn": custom_instance_profile_arn,
            "CustomJson": custom_json,
            "CustomSecurityGroupIds": custom_security_group_ids,
            "Packages": packages,
            "VolumeConfigurations": volume_configurations,
            "EnableAutoHealing": enable_auto_healing,
            "AutoAssignElasticIps": auto_assign_elastic_ips,
            "AutoAssignPublicIps": auto_assign_public_ips,
            "CustomRecipes": custom_recipes,
            "InstallUpdatesOnBoot": install_updates_on_boot,
            "UseEbsOptimizedInstances": use_ebs_optimized_instances,
            "LifecycleEventConfiguration": lifecycle_event_configuration,
        },
    )


async def delete(hub, ctx, layer_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a specified layer. You must first stop and then delete all associated instances or unassign registered instances. For more information, see How to Delete a Layer.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        layer_id(str): The layer ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.layer.delete(ctx, layer_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.layer.delete layer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="delete_layer",
        op_kwargs={"LayerId": layer_id},
    )


async def describe_all(hub, ctx, stack_id: str = None, layer_ids: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Requests a description of one or more layers in a specified stack.  This call accepts only one resource-identifying parameter.   Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        stack_id(str, optional): The stack ID. Defaults to None.
        layer_ids(List, optional): An array of layer IDs that specify the layers to be described. If you omit this parameter, DescribeLayers returns a description of every layer in the specified stack. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.layer.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.layer.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_layers",
        op_kwargs={"StackId": stack_id, "LayerIds": layer_ids},
    )


async def update(
    hub,
    ctx,
    layer_id: str,
    name: str = None,
    shortname: str = None,
    attributes: Dict = None,
    cloud_watch_logs_configuration: Dict = None,
    custom_instance_profile_arn: str = None,
    custom_json: str = None,
    custom_security_group_ids: List = None,
    packages: List = None,
    volume_configurations: List = None,
    enable_auto_healing: bool = None,
    auto_assign_elastic_ips: bool = None,
    auto_assign_public_ips: bool = None,
    custom_recipes: Dict = None,
    install_updates_on_boot: bool = None,
    use_ebs_optimized_instances: bool = None,
    lifecycle_event_configuration: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates a specified layer.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        layer_id(str): The layer ID.
        name(str, optional): The layer name, which is used by the console. Defaults to None.
        shortname(str, optional): For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS OpsWorks Stacks and by Chef. The short name is also used as the name for the directory where your app files are installed. It can have a maximum of 200 characters and must be in the following format: /\A[a-z0-9\-\_\.]+\Z/. The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the Layer Reference . Defaults to None.
        attributes(Dict, optional): One or more user-defined key/value pairs to be added to the stack attributes. Defaults to None.
        cloud_watch_logs_configuration(Dict, optional): Specifies CloudWatch Logs configuration options for the layer. For more information, see CloudWatchLogsLogStream. Defaults to None.
        custom_instance_profile_arn(str, optional): The ARN of an IAM profile to be used for all of the layer's EC2 instances. For more information about IAM ARNs, see Using Identifiers. Defaults to None.
        custom_json(str, optional): A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the layer's instances. For more information, see  Using Custom JSON. . Defaults to None.
        custom_security_group_ids(List, optional): An array containing the layer's custom security group IDs. Defaults to None.
        packages(List, optional): An array of Package objects that describe the layer's packages. Defaults to None.
        volume_configurations(List, optional): A VolumeConfigurations object that describes the layer's Amazon EBS volumes. Defaults to None.
        enable_auto_healing(bool, optional): Whether to disable auto healing for the layer. Defaults to None.
        auto_assign_elastic_ips(bool, optional): Whether to automatically assign an Elastic IP address to the layer's instances. For more information, see How to Edit a Layer. Defaults to None.
        auto_assign_public_ips(bool, optional): For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's instances. For more information, see How to Edit a Layer. Defaults to None.
        custom_recipes(Dict, optional): A LayerCustomRecipes object that specifies the layer's custom recipes. Defaults to None.
        install_updates_on_boot(bool, optional): Whether to install operating system and package updates when the instance boots. The default value is true. To control when updates are installed, set this value to false. You must then update your instances manually by using CreateDeployment to run the update_dependencies stack command or manually running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.   We strongly recommend using the default value of true, to ensure that your instances have the latest security updates. . Defaults to None.
        use_ebs_optimized_instances(bool, optional): Whether to use Amazon EBS-optimized instances. Defaults to None.
        lifecycle_event_configuration(Dict, optional): . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.layer.update(ctx, layer_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.layer.update layer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="update_layer",
        op_kwargs={
            "LayerId": layer_id,
            "Name": name,
            "Shortname": shortname,
            "Attributes": attributes,
            "CloudWatchLogsConfiguration": cloud_watch_logs_configuration,
            "CustomInstanceProfileArn": custom_instance_profile_arn,
            "CustomJson": custom_json,
            "CustomSecurityGroupIds": custom_security_group_ids,
            "Packages": packages,
            "VolumeConfigurations": volume_configurations,
            "EnableAutoHealing": enable_auto_healing,
            "AutoAssignElasticIps": auto_assign_elastic_ips,
            "AutoAssignPublicIps": auto_assign_public_ips,
            "CustomRecipes": custom_recipes,
            "InstallUpdatesOnBoot": install_updates_on_boot,
            "UseEbsOptimizedInstances": use_ebs_optimized_instances,
            "LifecycleEventConfiguration": lifecycle_event_configuration,
        },
    )
