"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def assign(hub, ctx, instance_id: str, layer_ids: List) -> None:
    r"""
    **Autogenerated function**

    Assign a registered instance to a layer.   You can assign registered on-premises instances to any layer type.   You can assign registered Amazon EC2 instances only to custom layers.   You cannot use this action with instances that were created with AWS OpsWorks Stacks.    Required Permissions: To use this action, an AWS Identity and Access Management (IAM) user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        instance_id(str): The instance ID.
        layer_ids(List): The layer ID, which must correspond to a custom layer. You cannot assign a registered instance to a built-in layer.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.instance.assign(ctx, instance_id=value, layer_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.instance.assign instance_id=value, layer_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="assign_instance",
        op_kwargs={"InstanceId": instance_id, "LayerIds": layer_ids},
    )


async def create(
    hub,
    ctx,
    stack_id: str,
    layer_ids: List,
    instance_type: str,
    auto_scaling_type: str = None,
    hostname: str = None,
    os: str = None,
    ami_id: str = None,
    ssh_key_name: str = None,
    availability_zone: str = None,
    virtualization_type: str = None,
    subnet_id: str = None,
    architecture: str = None,
    root_device_type: str = None,
    block_device_mappings: List = None,
    install_updates_on_boot: bool = None,
    ebs_optimized: bool = None,
    agent_version: str = None,
    tenancy: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an instance in a specified stack. For more information, see Adding an Instance to a Layer.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        stack_id(str): The stack ID.
        layer_ids(List): An array that contains the instance's layer IDs.
        instance_type(str): The instance type, such as t2.micro. For a list of supported instance types, open the stack in the console, choose Instances, and choose + Instance. The Size list contains the currently supported types. For more information, see Instance Families and Types. The parameter values that you use to specify the various types are in the API Name column of the Available Instance Types table.
        auto_scaling_type(str, optional): For load-based or time-based instances, the type. Windows stacks can use only time-based instances. Defaults to None.
        hostname(str, optional): The instance host name. Defaults to None.
        os(str, optional): The instance's operating system, which must be set to one of the following.   A supported Linux operating system: An Amazon Linux version, such as Amazon Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon Linux 2016.09, Amazon Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux 2015.03.   A supported Ubuntu operating system, such as Ubuntu 16.04 LTS, Ubuntu 14.04 LTS, or Ubuntu 12.04 LTS.    CentOS Linux 7     Red Hat Enterprise Linux 7    A supported Windows operating system, such as Microsoft Windows Server 2012 R2 Base, Microsoft Windows Server 2012 R2 with SQL Server Express, Microsoft Windows Server 2012 R2 with SQL Server Standard, or Microsoft Windows Server 2012 R2 with SQL Server Web.   A custom AMI: Custom.   For more information about the supported operating systems, see AWS OpsWorks Stacks Operating Systems. The default option is the current Amazon Linux version. If you set this parameter to Custom, you must use the CreateInstance action's AmiId parameter to specify the custom AMI that you want to use. Block device mappings are not supported if the value is Custom. For more information about supported operating systems, see Operating SystemsFor more information about how to use custom AMIs with AWS OpsWorks Stacks, see Using Custom AMIs. Defaults to None.
        ami_id(str, optional): A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported operating systems. For more information, see Using Custom AMIs.  If you specify a custom AMI, you must set Os to Custom. . Defaults to None.
        ssh_key_name(str, optional): The instance's Amazon EC2 key-pair name. Defaults to None.
        availability_zone(str, optional): The instance Availability Zone. For more information, see Regions and Endpoints. Defaults to None.
        virtualization_type(str, optional): The instance's virtualization type, paravirtual or hvm. Defaults to None.
        subnet_id(str, optional): The ID of the instance's subnet. If the stack is running in a VPC, you can use this parameter to override the stack's default subnet ID value and direct AWS OpsWorks Stacks to launch the instance in a different subnet. Defaults to None.
        architecture(str, optional): The instance architecture. The default option is x86_64. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see Instance Families and Types. Defaults to None.
        root_device_type(str, optional): The instance root device type. For more information, see Storage for the Root Device. Defaults to None.
        block_device_mappings(List, optional): An array of BlockDeviceMapping objects that specify the instance's block devices. For more information, see Block Device Mapping. Note that block device mappings are not supported for custom AMIs. Defaults to None.
        install_updates_on_boot(bool, optional): Whether to install operating system and package updates when the instance boots. The default value is true. To control when updates are installed, set this value to false. You must then update your instances manually by using CreateDeployment to run the update_dependencies stack command or by manually running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.   We strongly recommend using the default value of true to ensure that your instances have the latest security updates. . Defaults to None.
        ebs_optimized(bool, optional): Whether to create an Amazon EBS-optimized instance. Defaults to None.
        agent_version(str, optional): The default AWS OpsWorks Stacks agent version. You have the following options:    INHERIT - Use the stack's default agent version setting.    version_number - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.   The default setting is INHERIT. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2. Defaults to None.
        tenancy(str, optional): The instance's tenancy option. The default option is no tenancy, or if the instance is running in a VPC, inherit tenancy settings from the VPC. The following are valid values for this parameter: dedicated, default, or host. Because there are costs associated with changes in tenancy options, we recommend that you research tenancy options before choosing them for your instances. For more information about dedicated hosts, see Dedicated Hosts Overview and Amazon EC2 Dedicated Hosts. For more information about dedicated instances, see Dedicated Instances and Amazon EC2 Dedicated Instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.instance.create(
                ctx, stack_id=value, layer_ids=value, instance_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.instance.create stack_id=value, layer_ids=value, instance_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="create_instance",
        op_kwargs={
            "StackId": stack_id,
            "LayerIds": layer_ids,
            "InstanceType": instance_type,
            "AutoScalingType": auto_scaling_type,
            "Hostname": hostname,
            "Os": os,
            "AmiId": ami_id,
            "SshKeyName": ssh_key_name,
            "AvailabilityZone": availability_zone,
            "VirtualizationType": virtualization_type,
            "SubnetId": subnet_id,
            "Architecture": architecture,
            "RootDeviceType": root_device_type,
            "BlockDeviceMappings": block_device_mappings,
            "InstallUpdatesOnBoot": install_updates_on_boot,
            "EbsOptimized": ebs_optimized,
            "AgentVersion": agent_version,
            "Tenancy": tenancy,
        },
    )


async def delete(
    hub,
    ctx,
    instance_id: str,
    delete_elastic_ip: bool = None,
    delete_volumes: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Deletes a specified instance, which terminates the associated Amazon EC2 instance. You must stop an instance before you can delete it. For more information, see Deleting Instances.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        instance_id(str): The instance ID.
        delete_elastic_ip(bool, optional): Whether to delete the instance Elastic IP address. Defaults to None.
        delete_volumes(bool, optional): Whether to delete the instance's Amazon EBS volumes. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.instance.delete(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.instance.delete instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="delete_instance",
        op_kwargs={
            "InstanceId": instance_id,
            "DeleteElasticIp": delete_elastic_ip,
            "DeleteVolumes": delete_volumes,
        },
    )


async def deregister(hub, ctx, instance_id: str) -> None:
    r"""
    **Autogenerated function**

    Deregister a registered Amazon EC2 or on-premises instance. This action removes the instance from the stack and returns it to your control. This action cannot be used with instances that were created with AWS OpsWorks Stacks.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        instance_id(str): The instance ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.instance.deregister(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.instance.deregister instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="deregister_instance",
        op_kwargs={"InstanceId": instance_id},
    )


async def describe_all(
    hub, ctx, stack_id: str = None, layer_id: str = None, instance_ids: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Requests a description of a set of instances.  This call accepts only one resource-identifying parameter.   Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        stack_id(str, optional): A stack ID. If you use this parameter, DescribeInstances returns descriptions of the instances associated with the specified stack. Defaults to None.
        layer_id(str, optional): A layer ID. If you use this parameter, DescribeInstances returns descriptions of the instances associated with the specified layer. Defaults to None.
        instance_ids(List, optional): An array of instance IDs to be described. If you use this parameter, DescribeInstances returns a description of the specified instances. Otherwise, it returns a description of every instance. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.instance.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.instance.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_instances",
        op_kwargs={
            "StackId": stack_id,
            "LayerId": layer_id,
            "InstanceIds": instance_ids,
        },
    )


async def reboot(hub, ctx, instance_id: str) -> None:
    r"""
    **Autogenerated function**

    Reboots a specified instance. For more information, see Starting, Stopping, and Rebooting Instances.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        instance_id(str): The instance ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.instance.reboot(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.instance.reboot instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="reboot_instance",
        op_kwargs={"InstanceId": instance_id},
    )


async def register(
    hub,
    ctx,
    stack_id: str,
    hostname: str = None,
    public_ip: str = None,
    private_ip: str = None,
    rsa_public_key: str = None,
    rsa_public_key_fingerprint: str = None,
    instance_identity: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers instances that were created outside of AWS OpsWorks Stacks with a specified stack.  We do not recommend using this action to register instances. The complete registration operation includes two tasks: installing the AWS OpsWorks Stacks agent on the instance, and registering the instance with the stack. RegisterInstance handles only the second step. You should instead use the AWS CLI register command, which performs the entire registration operation. For more information, see  Registering an Instance with an AWS OpsWorks Stacks Stack.  Registered instances have the same requirements as instances that are created by using the CreateInstance API. For example, registered instances must be running a supported Linux-based operating system, and they must have a supported instance type. For more information about requirements for instances that you want to register, see  Preparing the Instance.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        stack_id(str): The ID of the stack that the instance is to be registered with.
        hostname(str, optional): The instance's hostname. Defaults to None.
        public_ip(str, optional): The instance's public IP address. Defaults to None.
        private_ip(str, optional): The instance's private IP address. Defaults to None.
        rsa_public_key(str, optional): The instances public RSA key. This key is used to encrypt communication between the instance and the service. Defaults to None.
        rsa_public_key_fingerprint(str, optional): The instances public RSA key fingerprint. Defaults to None.
        instance_identity(Dict, optional): An InstanceIdentity object that contains the instance's identity. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.instance.register(ctx, stack_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.instance.register stack_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="register_instance",
        op_kwargs={
            "StackId": stack_id,
            "Hostname": hostname,
            "PublicIp": public_ip,
            "PrivateIp": private_ip,
            "RsaPublicKey": rsa_public_key,
            "RsaPublicKeyFingerprint": rsa_public_key_fingerprint,
            "InstanceIdentity": instance_identity,
        },
    )


async def start(hub, ctx, instance_id: str) -> None:
    r"""
    **Autogenerated function**

    Starts a specified instance. For more information, see Starting, Stopping, and Rebooting Instances.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        instance_id(str): The instance ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.instance.start(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.instance.start instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="start_instance",
        op_kwargs={"InstanceId": instance_id},
    )


async def stop(hub, ctx, instance_id: str, force: bool = None) -> None:
    r"""
    **Autogenerated function**

    Stops a specified instance. When you stop a standard instance, the data disappears and must be reinstalled when you restart the instance. You can stop an Amazon EBS-backed instance without losing data. For more information, see Starting, Stopping, and Rebooting Instances.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        instance_id(str): The instance ID.
        force(bool, optional): Specifies whether to force an instance to stop. If the instance's root device type is ebs, or EBS-backed, adding the Force parameter to the StopInstances API call disassociates the AWS OpsWorks Stacks instance from EC2, and forces deletion of only the OpsWorks Stacks instance. You must also delete the formerly-associated instance in EC2 after troubleshooting and replacing the AWS OpsWorks Stacks instance with a new one. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.instance.stop(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.instance.stop instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="stop_instance",
        op_kwargs={"InstanceId": instance_id, "Force": force},
    )


async def unassign(hub, ctx, instance_id: str) -> None:
    r"""
    **Autogenerated function**

    Unassigns a registered instance from all layers that are using the instance. The instance remains in the stack as an unassigned instance, and can be assigned to another layer as needed. You cannot use this action with instances that were created with AWS OpsWorks Stacks.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        instance_id(str): The instance ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.instance.unassign(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.instance.unassign instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="unassign_instance",
        op_kwargs={"InstanceId": instance_id},
    )


async def update(
    hub,
    ctx,
    instance_id: str,
    layer_ids: List = None,
    instance_type: str = None,
    auto_scaling_type: str = None,
    hostname: str = None,
    os: str = None,
    ami_id: str = None,
    ssh_key_name: str = None,
    architecture: str = None,
    install_updates_on_boot: bool = None,
    ebs_optimized: bool = None,
    agent_version: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates a specified instance.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        instance_id(str): The instance ID.
        layer_ids(List, optional): The instance's layer IDs. Defaults to None.
        instance_type(str, optional): The instance type, such as t2.micro. For a list of supported instance types, open the stack in the console, choose Instances, and choose + Instance. The Size list contains the currently supported types. For more information, see Instance Families and Types. The parameter values that you use to specify the various types are in the API Name column of the Available Instance Types table. Defaults to None.
        auto_scaling_type(str, optional): For load-based or time-based instances, the type. Windows stacks can use only time-based instances. Defaults to None.
        hostname(str, optional): The instance host name. Defaults to None.
        os(str, optional): The instance's operating system, which must be set to one of the following. You cannot update an instance that is using a custom AMI.   A supported Linux operating system: An Amazon Linux version, such as Amazon Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon Linux 2016.09, Amazon Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux 2015.03.   A supported Ubuntu operating system, such as Ubuntu 16.04 LTS, Ubuntu 14.04 LTS, or Ubuntu 12.04 LTS.    CentOS Linux 7     Red Hat Enterprise Linux 7    A supported Windows operating system, such as Microsoft Windows Server 2012 R2 Base, Microsoft Windows Server 2012 R2 with SQL Server Express, Microsoft Windows Server 2012 R2 with SQL Server Standard, or Microsoft Windows Server 2012 R2 with SQL Server Web.   For more information about supported operating systems, see AWS OpsWorks Stacks Operating Systems. The default option is the current Amazon Linux version. If you set this parameter to Custom, you must use the AmiId parameter to specify the custom AMI that you want to use. For more information about supported operating systems, see Operating Systems. For more information about how to use custom AMIs with OpsWorks, see Using Custom AMIs.  You can specify a different Linux operating system for the updated stack, but you cannot change from Linux to Windows or Windows to Linux. . Defaults to None.
        ami_id(str, optional): The ID of the AMI that was used to create the instance. The value of this parameter must be the same AMI ID that the instance is already using. You cannot apply a new AMI to an instance by running UpdateInstance. UpdateInstance does not work on instances that are using custom AMIs. . Defaults to None.
        ssh_key_name(str, optional): The instance's Amazon EC2 key name. Defaults to None.
        architecture(str, optional): The instance architecture. Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see Instance Families and Types. Defaults to None.
        install_updates_on_boot(bool, optional): Whether to install operating system and package updates when the instance boots. The default value is true. To control when updates are installed, set this value to false. You must then update your instances manually by using CreateDeployment to run the update_dependencies stack command or by manually running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.   We strongly recommend using the default value of true, to ensure that your instances have the latest security updates. . Defaults to None.
        ebs_optimized(bool, optional): This property cannot be updated. Defaults to None.
        agent_version(str, optional): The default AWS OpsWorks Stacks agent version. You have the following options:    INHERIT - Use the stack's default agent version setting.    version_number - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, you must edit the instance configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version on the instance.   The default setting is INHERIT. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.instance.update(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.instance.update instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="update_instance",
        op_kwargs={
            "InstanceId": instance_id,
            "LayerIds": layer_ids,
            "InstanceType": instance_type,
            "AutoScalingType": auto_scaling_type,
            "Hostname": hostname,
            "Os": os,
            "AmiId": ami_id,
            "SshKeyName": ssh_key_name,
            "Architecture": architecture,
            "InstallUpdatesOnBoot": install_updates_on_boot,
            "EbsOptimized": ebs_optimized,
            "AgentVersion": agent_version,
        },
    )
