"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, layer_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a generated host name for the specified layer, based on the current host name theme.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        layer_id(str): The layer ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.hostname_suggestion.get(ctx, layer_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.hostname_suggestion.get layer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="get_hostname_suggestion",
        op_kwargs={"LayerId": layer_id},
    )
