"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(hub, ctx, elastic_load_balancer_name: str, layer_id: str) -> None:
    r"""
    **Autogenerated function**

    Attaches an Elastic Load Balancing load balancer to a specified layer. AWS OpsWorks Stacks does not support Application Load Balancer. You can only use Classic Load Balancer with AWS OpsWorks Stacks. For more information, see Elastic Load Balancing.  You must create the Elastic Load Balancing instance separately, by using the Elastic Load Balancing console, API, or CLI. For more information, see  Elastic Load Balancing Developer Guide.   Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        elastic_load_balancer_name(str): The Elastic Load Balancing instance's name.
        layer_id(str): The ID of the layer to which the Elastic Load Balancing instance is to be attached.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.elastic.load_balancer.attach(
                ctx, elastic_load_balancer_name=value, layer_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.elastic.load_balancer.attach elastic_load_balancer_name=value, layer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="attach_elastic_load_balancer",
        op_kwargs={
            "ElasticLoadBalancerName": elastic_load_balancer_name,
            "LayerId": layer_id,
        },
    )


async def describe_all(hub, ctx, stack_id: str = None, layer_ids: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes a stack's Elastic Load Balancing instances.  This call accepts only one resource-identifying parameter.   Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        stack_id(str, optional): A stack ID. The action describes the stack's Elastic Load Balancing instances. Defaults to None.
        layer_ids(List, optional): A list of layer IDs. The action describes the Elastic Load Balancing instances for the specified layers. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.elastic.load_balancer.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.elastic.load_balancer.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_elastic_load_balancers",
        op_kwargs={"StackId": stack_id, "LayerIds": layer_ids},
    )


async def detach(hub, ctx, elastic_load_balancer_name: str, layer_id: str) -> None:
    r"""
    **Autogenerated function**

    Detaches a specified Elastic Load Balancing instance from its layer.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        elastic_load_balancer_name(str): The Elastic Load Balancing instance's name.
        layer_id(str): The ID of the layer that the Elastic Load Balancing instance is attached to.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.elastic.load_balancer.detach(
                ctx, elastic_load_balancer_name=value, layer_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.elastic.load_balancer.detach elastic_load_balancer_name=value, layer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="detach_elastic_load_balancer",
        op_kwargs={
            "ElasticLoadBalancerName": elastic_load_balancer_name,
            "LayerId": layer_id,
        },
    )
