"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(hub, ctx, elastic_ip: str, instance_id: str = None) -> None:
    r"""
    **Autogenerated function**

    Associates one of the stack's registered Elastic IP addresses with a specified instance. The address must first be registered with the stack by calling RegisterElasticIp. For more information, see Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        elastic_ip(str): The Elastic IP address.
        instance_id(str, optional): The instance ID. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.elastic.ip.associate(ctx, elastic_ip=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.elastic.ip.associate elastic_ip=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="associate_elastic_ip",
        op_kwargs={"ElasticIp": elastic_ip, "InstanceId": instance_id},
    )


async def deregister(hub, ctx, elastic_ip: str) -> None:
    r"""
    **Autogenerated function**

    Deregisters a specified Elastic IP address. The address can then be registered by another stack. For more information, see Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        elastic_ip(str): The Elastic IP address.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.elastic.ip.deregister(ctx, elastic_ip=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.elastic.ip.deregister elastic_ip=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="deregister_elastic_ip",
        op_kwargs={"ElasticIp": elastic_ip},
    )


async def describe_all(
    hub, ctx, instance_id: str = None, stack_id: str = None, ips: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes Elastic IP addresses.  This call accepts only one resource-identifying parameter.   Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        instance_id(str, optional): The instance ID. If you include this parameter, DescribeElasticIps returns a description of the Elastic IP addresses associated with the specified instance. Defaults to None.
        stack_id(str, optional): A stack ID. If you include this parameter, DescribeElasticIps returns a description of the Elastic IP addresses that are registered with the specified stack. Defaults to None.
        ips(List, optional): An array of Elastic IP addresses to be described. If you include this parameter, DescribeElasticIps returns a description of the specified Elastic IP addresses. Otherwise, it returns a description of every Elastic IP address. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.elastic.ip.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.elastic.ip.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_elastic_ips",
        op_kwargs={"InstanceId": instance_id, "StackId": stack_id, "Ips": ips},
    )


async def disassociate(hub, ctx, elastic_ip: str) -> None:
    r"""
    **Autogenerated function**

    Disassociates an Elastic IP address from its instance. The address remains registered with the stack. For more information, see Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        elastic_ip(str): The Elastic IP address.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.elastic.ip.disassociate(ctx, elastic_ip=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.elastic.ip.disassociate elastic_ip=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="disassociate_elastic_ip",
        op_kwargs={"ElasticIp": elastic_ip},
    )


async def register(hub, ctx, elastic_ip: str, stack_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Registers an Elastic IP address with a specified stack. An address can be registered with only one stack at a time. If the address is already registered, you must first deregister it by calling DeregisterElasticIp. For more information, see Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        elastic_ip(str): The Elastic IP address.
        stack_id(str): The stack ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.elastic.ip.register(
                ctx, elastic_ip=value, stack_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.elastic.ip.register elastic_ip=value, stack_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="register_elastic_ip",
        op_kwargs={"ElasticIp": elastic_ip, "StackId": stack_id},
    )


async def update(hub, ctx, elastic_ip: str, name: str = None) -> None:
    r"""
    **Autogenerated function**

    Updates a registered Elastic IP address's name. For more information, see Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        elastic_ip(str): The IP address for which you want to update the name.
        name(str, optional): The new name. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.elastic.ip.update(ctx, elastic_ip=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.elastic.ip.update elastic_ip=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="update_elastic_ip",
        op_kwargs={"ElasticIp": elastic_ip, "Name": name},
    )
