"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(hub, ctx, ecs_cluster_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deregisters a specified Amazon ECS cluster from a stack. For more information, see  Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html.

    Args:
        ecs_cluster_arn(str): The cluster's Amazon Resource Number (ARN).
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.ecs_cluster.deregister(ctx, ecs_cluster_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.ecs_cluster.deregister ecs_cluster_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="deregister_ecs_cluster",
        op_kwargs={"EcsClusterArn": ecs_cluster_arn},
    )


async def describe_all(
    hub,
    ctx,
    ecs_cluster_arns: List = None,
    stack_id: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes Amazon ECS clusters that are registered with a stack. If you specify only a stack ID, you can use the MaxResults and NextToken parameters to paginate the response. However, AWS OpsWorks Stacks currently supports only one cluster per layer, so the result set has a maximum of one element.  Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack or an attached policy that explicitly grants permission. For more information about user permissions, see Managing User Permissions. This call accepts only one resource-identifying parameter.

    Args:
        ecs_cluster_arns(List, optional): A list of ARNs, one for each cluster to be described. Defaults to None.
        stack_id(str, optional): A stack ID. DescribeEcsClusters returns a description of the cluster that is registered with the stack. Defaults to None.
        next_token(str, optional): If the previous paginated request did not return all of the remaining results, the response object'sNextToken parameter value is set to a token. To retrieve the next set of results, call DescribeEcsClusters again and assign that token to the request object's NextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. Defaults to None.
        max_results(int, optional): To receive a paginated response, use this parameter to specify the maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a NextToken value that you can assign to the NextToken request parameter to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.ecs_cluster.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.ecs_cluster.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_ecs_clusters",
        op_kwargs={
            "EcsClusterArns": ecs_cluster_arns,
            "StackId": stack_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def register(hub, ctx, ecs_cluster_arn: str, stack_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Registers a specified Amazon ECS cluster with a stack. You can register only one cluster with a stack. A cluster can be registered with only one stack. For more information, see  Resource Management.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack or an attached policy that explicitly grants permissions. For more information on user permissions, see  Managing User Permissions.

    Args:
        ecs_cluster_arn(str): The cluster's ARN.
        stack_id(str): The stack ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.ecs_cluster.register(
                ctx, ecs_cluster_arn=value, stack_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.ecs_cluster.register ecs_cluster_arn=value, stack_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="register_ecs_cluster",
        op_kwargs={"EcsClusterArn": ecs_cluster_arn, "StackId": stack_id},
    )
