"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    stack_id: str,
    command: Dict,
    app_id: str = None,
    instance_ids: List = None,
    layer_ids: List = None,
    comment: str = None,
    custom_json: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Runs deployment or stack commands. For more information, see Deploying Apps and Run Stack Commands.  Required Permissions: To use this action, an IAM user must have a Deploy or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        stack_id(str): The stack ID.
        app_id(str, optional): The app ID. This parameter is required for app deployments, but not for other deployment commands. Defaults to None.
        instance_ids(List, optional): The instance IDs for the deployment targets. Defaults to None.
        layer_ids(List, optional): The layer IDs for the deployment targets. Defaults to None.
        command(Dict): A DeploymentCommand object that specifies the deployment command and any associated arguments.
        comment(str, optional): A user-defined comment. Defaults to None.
        custom_json(str, optional): A string that contains user-defined, custom JSON. You can use this parameter to override some corresponding default stack configuration JSON values. The string should be in the following format:  "{\"key1\": \"value1\", \"key2\": \"value2\",...}"  For more information about custom JSON, see Use Custom JSON to Modify the Stack Configuration Attributes and Overriding Attributes With Custom JSON. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.deployment.create(ctx, stack_id=value, command=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.deployment.create stack_id=value, command=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="create_deployment",
        op_kwargs={
            "StackId": stack_id,
            "AppId": app_id,
            "InstanceIds": instance_ids,
            "LayerIds": layer_ids,
            "Command": command,
            "Comment": comment,
            "CustomJson": custom_json,
        },
    )


async def describe_all(
    hub, ctx, stack_id: str = None, app_id: str = None, deployment_ids: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Requests a description of a specified set of deployments.  This call accepts only one resource-identifying parameter.   Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        stack_id(str, optional): The stack ID. If you include this parameter, the command returns a description of the commands associated with the specified stack. Defaults to None.
        app_id(str, optional): The app ID. If you include this parameter, the command returns a description of the commands associated with the specified app. Defaults to None.
        deployment_ids(List, optional): An array of deployment IDs to be described. If you include this parameter, the command returns a description of the specified deployments. Otherwise, it returns a description of every deployment. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.deployment.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.deployment.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_deployments",
        op_kwargs={
            "StackId": stack_id,
            "AppId": app_id,
            "DeploymentIds": deployment_ids,
        },
    )
