"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    deployment_id: str = None,
    instance_id: str = None,
    command_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the results of specified commands.  This call accepts only one resource-identifying parameter.   Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        deployment_id(str, optional): The deployment ID. If you include this parameter, DescribeCommands returns a description of the commands associated with the specified deployment. Defaults to None.
        instance_id(str, optional): The instance ID. If you include this parameter, DescribeCommands returns a description of the commands associated with the specified instance. Defaults to None.
        command_ids(List, optional): An array of command IDs. If you include this parameter, DescribeCommands returns a description of the specified commands. Otherwise, it returns a description of every command. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.command.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.command.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_commands",
        op_kwargs={
            "DeploymentId": deployment_id,
            "InstanceId": instance_id,
            "CommandIds": command_ids,
        },
    )
