"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, stack_id: str = None, app_ids: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Requests a description of a specified set of apps.  This call accepts only one resource-identifying parameter.   Required Permissions: To use this action, an IAM user must have a Show, Deploy, or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information about user permissions, see Managing User Permissions.

    Args:
        stack_id(str, optional): The app stack ID. If you use this parameter, DescribeApps returns a description of the apps in the specified stack. Defaults to None.
        app_ids(List, optional): An array of app IDs for the apps to be described. If you use this parameter, DescribeApps returns a description of the specified apps. Otherwise, it returns a description of every app. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.apps.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.apps.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="describe_apps",
        op_kwargs={"StackId": stack_id, "AppIds": app_ids},
    )
