"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    stack_id: str,
    name: str,
    type_: str,
    shortname: str = None,
    description: str = None,
    data_sources: List = None,
    app_source: Dict = None,
    domains: List = None,
    enable_ssl: bool = None,
    ssl_configuration: Dict = None,
    attributes: Dict = None,
    environment: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an app for a specified stack. For more information, see Creating Apps.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        stack_id(str): The stack ID.
        shortname(str, optional): The app's short name. Defaults to None.
        name(str): The app name.
        description(str, optional): A description of the app. Defaults to None.
        data_sources(List, optional): The app's data source. Defaults to None.
        type_(str): The app type. Each supported type is associated with a particular layer. For example, PHP applications are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members of the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own Deploy recipes, specify other.
        app_source(Dict, optional): A Source object that specifies the app repository. Defaults to None.
        domains(List, optional): The app virtual host settings, with multiple domains separated by commas. For example: 'www.example.com, example.com' . Defaults to None.
        enable_ssl(bool, optional): Whether to enable SSL for the app. Defaults to None.
        ssl_configuration(Dict, optional): An SslConfiguration object with the SSL configuration. Defaults to None.
        attributes(Dict, optional): One or more user-defined key/value pairs to be added to the stack attributes. Defaults to None.
        environment(List, optional): An array of EnvironmentVariable objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instance. For more information, see  Environment Variables. There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20KB)."  If you have specified one or more environment variables, you cannot modify the stack's Chef version. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.app.create(ctx, stack_id=value, name=value, type_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.app.create stack_id=value, name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="create_app",
        op_kwargs={
            "StackId": stack_id,
            "Shortname": shortname,
            "Name": name,
            "Description": description,
            "DataSources": data_sources,
            "Type": type_,
            "AppSource": app_source,
            "Domains": domains,
            "EnableSsl": enable_ssl,
            "SslConfiguration": ssl_configuration,
            "Attributes": attributes,
            "Environment": environment,
        },
    )


async def delete(hub, ctx, app_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a specified app.  Required Permissions: To use this action, an IAM user must have a Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        app_id(str): The app ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.app.delete(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.app.delete app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="delete_app",
        op_kwargs={"AppId": app_id},
    )


async def update(
    hub,
    ctx,
    app_id: str,
    name: str = None,
    description: str = None,
    data_sources: List = None,
    type_: str = None,
    app_source: Dict = None,
    domains: List = None,
    enable_ssl: bool = None,
    ssl_configuration: Dict = None,
    attributes: Dict = None,
    environment: List = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates a specified app.  Required Permissions: To use this action, an IAM user must have a Deploy or Manage permissions level for the stack, or an attached policy that explicitly grants permissions. For more information on user permissions, see Managing User Permissions.

    Args:
        app_id(str): The app ID.
        name(str, optional): The app name. Defaults to None.
        description(str, optional): A description of the app. Defaults to None.
        data_sources(List, optional): The app's data sources. Defaults to None.
        type_(str, optional): The app type. Defaults to None.
        app_source(Dict, optional): A Source object that specifies the app repository. Defaults to None.
        domains(List, optional): The app's virtual host settings, with multiple domains separated by commas. For example: 'www.example.com, example.com' . Defaults to None.
        enable_ssl(bool, optional): Whether SSL is enabled for the app. Defaults to None.
        ssl_configuration(Dict, optional): An SslConfiguration object with the SSL configuration. Defaults to None.
        attributes(Dict, optional): One or more user-defined key/value pairs to be added to the stack attributes. Defaults to None.
        environment(List, optional): An array of EnvironmentVariable objects that specify environment variables to be associated with the app. After you deploy the app, these variables are defined on the associated app server instances.For more information, see  Environment Variables. There is no specific limit on the number of environment variables. However, the size of the associated data structure - which includes the variables' names, values, and protected flag values - cannot exceed 20 KB. This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the message, "Environment: is too large (maximum is 20 KB)."  If you have specified one or more environment variables, you cannot modify the stack's Chef version. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.app.update(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.app.update app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="update_app",
        op_kwargs={
            "AppId": app_id,
            "Name": name,
            "Description": description,
            "DataSources": data_sources,
            "Type": type_,
            "AppSource": app_source,
            "Domains": domains,
            "EnableSsl": enable_ssl,
            "SslConfiguration": ssl_configuration,
            "Attributes": attributes,
            "Environment": environment,
        },
    )
