"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def grant(hub, ctx, instance_id: str, valid_for_in_minutes: int = None) -> Dict:
    r"""
    **Autogenerated function**

     This action can be used only with Windows stacks.  Grants RDP access to a Windows instance for a specified time period.

    Args:
        instance_id(str): The instance's AWS OpsWorks Stacks ID.
        valid_for_in_minutes(int, optional): The length of time (in minutes) that the grant is valid. When the grant expires at the end of this period, the user will no longer be able to use the credentials to log in. If the user is logged in at the time, he or she automatically will be logged out. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.opswork.access.grant(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.opswork.access.grant instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="opsworks",
        operation="grant_access",
        op_kwargs={
            "InstanceId": instance_id,
            "ValidForInMinutes": valid_for_in_minutes,
        },
    )
