"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, studio_id: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Repairs the SSO configuration for a given studio. If the studio has a valid AWS SSO configuration currently associated with it, this operation will fail with a validation error. If the studio does not have a valid AWS SSO configuration currently associated with it, then a new AWS SSO application is created for the studio and the studio is changed to the READY state. After the AWS SSO application is repaired, you must use the Amazon Nimble Studio console to add administrators and users to your studio.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.sso_configuration_repair.start(
                ctx, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.sso_configuration_repair.start studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="start_studio_sso_configuration_repair",
        op_kwargs={"clientToken": client_token, "studioId": studio_id},
    )
