"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, principal_id: str, studio_id: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Delete a user from studio membership.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        principal_id(str): The principal ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.member.delete(
                ctx, principal_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.member.delete principal_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="delete_studio_member",
        op_kwargs={
            "clientToken": client_token,
            "principalId": principal_id,
            "studioId": studio_id,
        },
    )


async def get(hub, ctx, principal_id: str, studio_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get a user's membership in a studio.

    Args:
        principal_id(str): The principal ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.member.get(
                ctx, principal_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.member.get principal_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="get_studio_member",
        op_kwargs={"principalId": principal_id, "studioId": studio_id},
    )


async def list_all(
    hub, ctx, studio_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Get all users in a given studio membership.

    Args:
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.member.list_all(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.member.list_all studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="list_studio_members",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "studioId": studio_id,
        },
    )


async def put_multiple(
    hub,
    ctx,
    identity_store_id: str,
    members: List,
    studio_id: str,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Add/update users with given persona to studio membership.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        identity_store_id(str): The ID of the identity store.
        members(List): A list of members.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.member.put_multiple(
                ctx, identity_store_id=value, members=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.member.put_multiple identity_store_id=value, members=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="put_studio_members",
        op_kwargs={
            "clientToken": client_token,
            "identityStoreId": identity_store_id,
            "members": members,
            "studioId": studio_id,
        },
    )
