"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    admin_role_arn: str,
    display_name: str,
    studio_name: str,
    user_role_arn: str,
    client_token: str = None,
    studio_encryption_configuration: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new Studio. When creating a Studio, two IAM roles must be provided: the admin role and the user Role. These roles are assumed by your users when they log in to the Nimble Studio portal. The user role must have the AmazonNimbleStudio-StudioUser managed policy attached for the portal to function properly. The Admin Role must have the AmazonNimbleStudio-StudioAdmin managed policy attached for the portal to function properly. You may optionally specify a KMS key in the StudioEncryptionConfiguration. In Nimble Studio, resource names, descriptions, initialization scripts, and other data you provide are always encrypted at rest using an AWS KMS key. By default, this key is owned by AWS and managed on your behalf. You may provide your own AWS KMS key when calling CreateStudio to encrypt this data using a key you own and manage. When providing an AWS KMS key during studio creation, Nimble Studio creates KMS grants in your account to provide your studio user and admin roles access to these KMS keys. If you delete this grant, the studio will no longer be accessible to your portal users. If you delete the studio KMS key, your studio will no longer be accessible.

    Args:
        admin_role_arn(str): The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal.
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        display_name(str): A friendly name for the studio.
        studio_encryption_configuration(Dict, optional): The studio encryption configuration. Defaults to None.
        studio_name(str): The studio name that is used in the URL of the Nimble Studio portal when accessed by Nimble Studio users.
        tags(Dict, optional): A collection of labels, in the form of key:value pairs, that apply to this resource. Defaults to None.
        user_role_arn(str): The IAM role that Studio Users will assume when logging in to the Nimble Studio portal.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.init.create(
                ctx,
                admin_role_arn=value,
                display_name=value,
                studio_name=value,
                user_role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.init.create admin_role_arn=value, display_name=value, studio_name=value, user_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="create_studio",
        op_kwargs={
            "adminRoleArn": admin_role_arn,
            "clientToken": client_token,
            "displayName": display_name,
            "studioEncryptionConfiguration": studio_encryption_configuration,
            "studioName": studio_name,
            "tags": tags,
            "userRoleArn": user_role_arn,
        },
    )


async def delete(hub, ctx, studio_id: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Delete a studio resource.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.init.delete(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.init.delete studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="delete_studio",
        op_kwargs={"clientToken": client_token, "studioId": studio_id},
    )


async def get(hub, ctx, studio_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get a Studio resource.

    Args:
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.init.get(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.init.get studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="get_studio",
        op_kwargs={"studioId": studio_id},
    )


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List studios in your AWS account in the requested AWS Region.

    Args:
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="list_studios",
        op_kwargs={"nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    studio_id: str,
    admin_role_arn: str = None,
    client_token: str = None,
    display_name: str = None,
    user_role_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update a Studio resource. Currently, this operation only supports updating the displayName of your studio.

    Args:
        admin_role_arn(str, optional): The IAM role that Studio Admins will assume when logging in to the Nimble Studio portal. Defaults to None.
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        display_name(str, optional): A friendly name for the studio. Defaults to None.
        studio_id(str): The studio ID.
        user_role_arn(str, optional): The IAM role that Studio Users will assume when logging in to the Nimble Studio portal. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.init.update(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.init.update studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="update_studio",
        op_kwargs={
            "adminRoleArn": admin_role_arn,
            "clientToken": client_token,
            "displayName": display_name,
            "studioId": studio_id,
            "userRoleArn": user_role_arn,
        },
    )
