"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    studio_id: str,
    type_: str,
    client_token: str = None,
    configuration: Dict = None,
    description: str = None,
    ec2_security_group_ids: List = None,
    initialization_scripts: List = None,
    script_parameters: List = None,
    subtype: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a studio component resource.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        configuration(Dict, optional): The configuration of the studio component, based on component type. Defaults to None.
        description(str, optional): The description. Defaults to None.
        ec2_security_group_ids(List, optional): The EC2 security groups that control access to the studio component. Defaults to None.
        initialization_scripts(List, optional): Initialization scripts for studio components. Defaults to None.
        name(str): The name for the studio component.
        script_parameters(List, optional): Parameters for the studio component scripts. Defaults to None.
        studio_id(str): The studio ID.
        subtype(str, optional): The specific subtype of a studio component. Defaults to None.
        tags(Dict, optional): A collection of labels, in the form of key:value pairs, that apply to this resource. Defaults to None.
        type_(str): The type of the studio component.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.component.create(
                ctx, name=value, studio_id=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.component.create name=value, studio_id=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="create_studio_component",
        op_kwargs={
            "clientToken": client_token,
            "configuration": configuration,
            "description": description,
            "ec2SecurityGroupIds": ec2_security_group_ids,
            "initializationScripts": initialization_scripts,
            "name": name,
            "scriptParameters": script_parameters,
            "studioId": studio_id,
            "subtype": subtype,
            "tags": tags,
            "type": type_,
        },
    )


async def delete(
    hub, ctx, studio_component_id: str, studio_id: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a studio component resource.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        studio_component_id(str): The studio component ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.component.delete(
                ctx, studio_component_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.component.delete studio_component_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="delete_studio_component",
        op_kwargs={
            "clientToken": client_token,
            "studioComponentId": studio_component_id,
            "studioId": studio_id,
        },
    )


async def get(hub, ctx, studio_component_id: str, studio_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a studio component resource.

    Args:
        studio_component_id(str): The studio component ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.component.get(
                ctx, studio_component_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.component.get studio_component_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="get_studio_component",
        op_kwargs={"studioComponentId": studio_component_id, "studioId": studio_id},
    )


async def list_all(
    hub,
    ctx,
    studio_id: str,
    max_results: int = None,
    next_token: str = None,
    states: List = None,
    types: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the StudioComponents in a studio.

    Args:
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        states(List, optional): A list of states. Defaults to None.
        studio_id(str): The studio ID.
        types(List, optional): The types. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.component.list_all(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.component.list_all studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="list_studio_components",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "states": states,
            "studioId": studio_id,
            "types": types,
        },
    )


async def update(
    hub,
    ctx,
    studio_component_id: str,
    studio_id: str,
    client_token: str = None,
    configuration: Dict = None,
    description: str = None,
    ec2_security_group_ids: List = None,
    initialization_scripts: List = None,
    name: str = None,
    script_parameters: List = None,
    subtype: str = None,
    type_: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a studio component resource.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        configuration(Dict, optional): The configuration of the studio component, based on component type. Defaults to None.
        description(str, optional): The description. Defaults to None.
        ec2_security_group_ids(List, optional): The EC2 security groups that control access to the studio component. Defaults to None.
        initialization_scripts(List, optional): Initialization scripts for studio components. Defaults to None.
        name(str, optional): The name for the studio component. Defaults to None.
        script_parameters(List, optional): Parameters for the studio component scripts. Defaults to None.
        studio_component_id(str): The studio component ID.
        studio_id(str): The studio ID.
        subtype(str, optional): The specific subtype of a studio component. Defaults to None.
        type_(str, optional): The type of the studio component. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.studio.component.update(
                ctx, studio_component_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.studio.component.update studio_component_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="update_studio_component",
        op_kwargs={
            "clientToken": client_token,
            "configuration": configuration,
            "description": description,
            "ec2SecurityGroupIds": ec2_security_group_ids,
            "initializationScripts": initialization_scripts,
            "name": name,
            "scriptParameters": script_parameters,
            "studioComponentId": studio_component_id,
            "studioId": studio_id,
            "subtype": subtype,
            "type": type_,
        },
    )
