"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    session_id: str,
    studio_id: str,
    client_token: str = None,
    expiration_in_seconds: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a streaming session stream for a streaming session. After invoking this API, invoke GetStreamingSessionStream with the returned streamId to poll the resource until it is in state READY.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        expiration_in_seconds(int, optional): The expiration time in seconds. Defaults to None.
        session_id(str): The session ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.streaming.session.stream.create(
                ctx, session_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.streaming.session.stream.create session_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="create_streaming_session_stream",
        op_kwargs={
            "clientToken": client_token,
            "expirationInSeconds": expiration_in_seconds,
            "sessionId": session_id,
            "studioId": studio_id,
        },
    )


async def get(hub, ctx, session_id: str, stream_id: str, studio_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a StreamingSessionStream for a streaming session. Invoke this operation to poll the resource after invoking CreateStreamingSessionStream. After the StreamingSessionStream changes to the state READY, the url property will contain a stream to be used with the DCV streaming client.

    Args:
        session_id(str): The session ID.
        stream_id(str): The stream ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.streaming.session.stream.get(
                ctx, session_id=value, stream_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.streaming.session.stream.get session_id=value, stream_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="get_streaming_session_stream",
        op_kwargs={
            "sessionId": session_id,
            "streamId": stream_id,
            "studioId": studio_id,
        },
    )
