"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    studio_id: str,
    client_token: str = None,
    ec2_instance_type: str = None,
    launch_profile_id: str = None,
    streaming_image_id: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a streaming session in a studio. After invoking this operation, you must poll GetStreamingSession until the streaming session is in state READY.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        ec2_instance_type(str, optional): The EC2 Instance type used for the streaming session. Defaults to None.
        launch_profile_id(str, optional): The launch profile ID. Defaults to None.
        streaming_image_id(str, optional): The ID of the streaming image. Defaults to None.
        studio_id(str): The studio ID.
        tags(Dict, optional): A collection of labels, in the form of key:value pairs, that apply to this resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.streaming.session.init.create(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.streaming.session.init.create studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="create_streaming_session",
        op_kwargs={
            "clientToken": client_token,
            "ec2InstanceType": ec2_instance_type,
            "launchProfileId": launch_profile_id,
            "streamingImageId": streaming_image_id,
            "studioId": studio_id,
            "tags": tags,
        },
    )


async def delete(
    hub, ctx, session_id: str, studio_id: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes streaming session resource. After invoking this operation, use GetStreamingSession to poll the resource until it transitions to a DELETED state. A streaming session will count against your streaming session quota until it is marked DELETED.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        session_id(str): The session ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.streaming.session.init.delete(
                ctx, session_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.streaming.session.init.delete session_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="delete_streaming_session",
        op_kwargs={
            "clientToken": client_token,
            "sessionId": session_id,
            "studioId": studio_id,
        },
    )


async def get(hub, ctx, session_id: str, studio_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets StreamingSession resource. Invoke this operation to poll for a streaming session state while creating or deleting a session.

    Args:
        session_id(str): The session ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.streaming.session.init.get(
                ctx, session_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.streaming.session.init.get session_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="get_streaming_session",
        op_kwargs={"sessionId": session_id, "studioId": studio_id},
    )


async def list_all(
    hub,
    ctx,
    studio_id: str,
    created_by: str = None,
    next_token: str = None,
    session_ids: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the streaming image resources in a studio.

    Args:
        created_by(str, optional): The user ID. Defaults to None.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        session_ids(str, optional): A collection of session IDs. Defaults to None.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.streaming.session.init.list_all(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.streaming.session.init.list_all studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="list_streaming_sessions",
        op_kwargs={
            "createdBy": created_by,
            "nextToken": next_token,
            "sessionIds": session_ids,
            "studioId": studio_id,
        },
    )
