"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    ec2_image_id: str,
    name: str,
    studio_id: str,
    client_token: str = None,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a streaming image resource in a studio.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        description(str, optional): A human-readable description of the streaming image. Defaults to None.
        ec2_image_id(str): The ID of an EC2 machine image with which to create this streaming image.
        name(str): A friendly name for a streaming image resource.
        studio_id(str): The studio ID.
        tags(Dict, optional): A collection of labels, in the form of key:value pairs, that apply to this resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.streaming.image.create(
                ctx, ec2_image_id=value, name=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.streaming.image.create ec2_image_id=value, name=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="create_streaming_image",
        op_kwargs={
            "clientToken": client_token,
            "description": description,
            "ec2ImageId": ec2_image_id,
            "name": name,
            "studioId": studio_id,
            "tags": tags,
        },
    )


async def delete(
    hub, ctx, streaming_image_id: str, studio_id: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Delete streaming image.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        streaming_image_id(str): The streaming image ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.streaming.image.delete(
                ctx, streaming_image_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.streaming.image.delete streaming_image_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="delete_streaming_image",
        op_kwargs={
            "clientToken": client_token,
            "streamingImageId": streaming_image_id,
            "studioId": studio_id,
        },
    )


async def get(hub, ctx, streaming_image_id: str, studio_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get streaming image.

    Args:
        streaming_image_id(str): The streaming image ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.streaming.image.get(
                ctx, streaming_image_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.streaming.image.get streaming_image_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="get_streaming_image",
        op_kwargs={"streamingImageId": streaming_image_id, "studioId": studio_id},
    )


async def list_all(
    hub, ctx, studio_id: str, next_token: str = None, owner: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the streaming image resources available to this studio. This list will contain both images provided by AWS, as well as streaming images that you have created in your studio.

    Args:
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        owner(str, optional): The owner. Defaults to None.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.streaming.image.list_all(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.streaming.image.list_all studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="list_streaming_images",
        op_kwargs={"nextToken": next_token, "owner": owner, "studioId": studio_id},
    )


async def update(
    hub,
    ctx,
    streaming_image_id: str,
    studio_id: str,
    client_token: str = None,
    description: str = None,
    name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update streaming image.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        description(str, optional): The description. Defaults to None.
        name(str, optional): The name for the streaming image. Defaults to None.
        streaming_image_id(str): The streaming image ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.streaming.image.update(
                ctx, streaming_image_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.streaming.image.update streaming_image_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="update_streaming_image",
        op_kwargs={
            "clientToken": client_token,
            "description": description,
            "name": name,
            "streamingImageId": streaming_image_id,
            "studioId": studio_id,
        },
    )
