"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates tags for a resource, given its ARN.

    Args:
        resource_arn(str): The ARN of the target resource for tagging operations.
        tags(Dict, optional): A collection of labels, in the form of key:value pairs, that apply to this resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.resource.tag(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.resource.tag resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="tag_resource",
        op_kwargs={"resourceArn": resource_arn, "tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the tags for a resource.

    Args:
        resource_arn(str): The ARN of the target resource for tagging operations.
        tag_keys(List): An array of tag keys to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.resource.untag(ctx, resource_arn=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="untag_resource",
        op_kwargs={"resourceArn": resource_arn, "tagKeys": tag_keys},
    )
