"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    launch_profile_id: str,
    launch_profile_protocol_versions: List,
    launch_purpose: str,
    platform: str,
    studio_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Get a launch profile initialization.

    Args:
        launch_profile_id(str): The launch profile ID.
        launch_profile_protocol_versions(List): A collection of launch profile protocol versions.
        launch_purpose(str): The launch purpose.
        platform(str): The platform.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.launch_profile.initialization.get(
                ctx,
                launch_profile_id=value,
                launch_profile_protocol_versions=value,
                launch_purpose=value,
                platform=value,
                studio_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.launch_profile.initialization.get launch_profile_id=value, launch_profile_protocol_versions=value, launch_purpose=value, platform=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="get_launch_profile_initialization",
        op_kwargs={
            "launchProfileId": launch_profile_id,
            "launchProfileProtocolVersions": launch_profile_protocol_versions,
            "launchPurpose": launch_purpose,
            "platform": platform,
            "studioId": studio_id,
        },
    )
