"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    ec2_subnet_ids: List,
    launch_profile_protocol_versions: List,
    name: str,
    stream_configuration: Dict,
    studio_component_ids: List,
    studio_id: str,
    client_token: str = None,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a launch profile.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        description(str, optional): The description. Defaults to None.
        ec2_subnet_ids(List): .
        launch_profile_protocol_versions(List): The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".
        name(str): The name for the launch profile.
        stream_configuration(Dict): A configuration for a streaming session.
        studio_component_ids(List): Unique identifiers for a collection of studio components that can be used with this launch profile.
        studio_id(str): The studio ID.
        tags(Dict, optional): A collection of labels, in the form of key:value pairs, that apply to this resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.launch_profile.init.create(
                ctx,
                ec2_subnet_ids=value,
                launch_profile_protocol_versions=value,
                name=value,
                stream_configuration=value,
                studio_component_ids=value,
                studio_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.launch_profile.init.create ec2_subnet_ids=value, launch_profile_protocol_versions=value, name=value, stream_configuration=value, studio_component_ids=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="create_launch_profile",
        op_kwargs={
            "clientToken": client_token,
            "description": description,
            "ec2SubnetIds": ec2_subnet_ids,
            "launchProfileProtocolVersions": launch_profile_protocol_versions,
            "name": name,
            "streamConfiguration": stream_configuration,
            "studioComponentIds": studio_component_ids,
            "studioId": studio_id,
            "tags": tags,
        },
    )


async def delete(
    hub, ctx, launch_profile_id: str, studio_id: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Permanently delete a launch profile.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        launch_profile_id(str): The launch profile ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.launch_profile.init.delete(
                ctx, launch_profile_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.launch_profile.init.delete launch_profile_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="delete_launch_profile",
        op_kwargs={
            "clientToken": client_token,
            "launchProfileId": launch_profile_id,
            "studioId": studio_id,
        },
    )


async def get(hub, ctx, launch_profile_id: str, studio_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get a launch profile.

    Args:
        launch_profile_id(str): The launch profile ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.launch_profile.init.get(
                ctx, launch_profile_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.launch_profile.init.get launch_profile_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="get_launch_profile",
        op_kwargs={"launchProfileId": launch_profile_id, "studioId": studio_id},
    )


async def list_all(
    hub,
    ctx,
    studio_id: str,
    max_results: int = None,
    next_token: str = None,
    principal_id: str = None,
    states: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List all the launch profiles a studio.

    Args:
        max_results(int, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        principal_id(str, optional): The principal ID. Defaults to None.
        states(List, optional): A list of states. Defaults to None.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.launch_profile.init.list_all(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.launch_profile.init.list_all studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="list_launch_profiles",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "principalId": principal_id,
            "states": states,
            "studioId": studio_id,
        },
    )


async def update(
    hub,
    ctx,
    launch_profile_id: str,
    studio_id: str,
    client_token: str = None,
    description: str = None,
    launch_profile_protocol_versions: List = None,
    name: str = None,
    stream_configuration: Dict = None,
    studio_component_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update a launch profile.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        description(str, optional): The description. Defaults to None.
        launch_profile_id(str): The launch profile ID.
        launch_profile_protocol_versions(List, optional): The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31". Defaults to None.
        name(str, optional): The name for the launch profile. Defaults to None.
        stream_configuration(Dict, optional): A configuration for a streaming session. Defaults to None.
        studio_component_ids(List, optional): Unique identifiers for a collection of studio components that can be used with this launch profile. Defaults to None.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.launch_profile.init.update(
                ctx, launch_profile_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.launch_profile.init.update launch_profile_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="update_launch_profile",
        op_kwargs={
            "clientToken": client_token,
            "description": description,
            "launchProfileId": launch_profile_id,
            "launchProfileProtocolVersions": launch_profile_protocol_versions,
            "name": name,
            "streamConfiguration": stream_configuration,
            "studioComponentIds": studio_component_ids,
            "studioId": studio_id,
        },
    )
