"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, launch_profile_id: str, studio_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Launch profile details include the launch profile resource and summary information of resources that are used by, or available to, the launch profile. This includes the name and description of all studio components used by the launch profiles, and the name and description of streaming images that can be used with this launch profile.

    Args:
        launch_profile_id(str): The launch profile ID.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.launch_profile.detail.get_all(
                ctx, launch_profile_id=value, studio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.launch_profile.detail.get_all launch_profile_id=value, studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="get_launch_profile_details",
        op_kwargs={"launchProfileId": launch_profile_id, "studioId": studio_id},
    )
