"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def accept(
    hub, ctx, studio_id: str, client_token: str = None, eula_ids: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Accept EULAs.

    Args:
        client_token(str, optional): To make an idempotent API request using one of these actions, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails with a ValidationException error. Defaults to None.
        eula_ids(List, optional): The EULA ID. Defaults to None.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.eulas.accept(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.eulas.accept studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="accept_eulas",
        op_kwargs={
            "clientToken": client_token,
            "eulaIds": eula_ids,
            "studioId": studio_id,
        },
    )


async def list_(hub, ctx, eula_ids: List = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List Eulas.

    Args:
        eula_ids(List, optional): A collection of EULA IDs. Defaults to None.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.eulas.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.eulas.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="list_eulas",
        op_kwargs={"eulaIds": eula_ids, "nextToken": next_token},
    )
