"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, eula_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get Eula.

    Args:
        eula_id(str): The EULA ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.eula.init.get(ctx, eula_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.eula.init.get eula_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="nimble", operation="get_eula", op_kwargs={"eulaId": eula_id}
    )
