"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub, ctx, studio_id: str, eula_ids: List = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List Eula Acceptances.

    Args:
        eula_ids(List, optional): A collection of EULA IDs. Defaults to None.
        next_token(str, optional): The token for the next set of results, or null if there are no more results. Defaults to None.
        studio_id(str): The studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.nimble.eula.acceptance.list_all(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.nimble.eula.acceptance.list_all studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="nimble",
        operation="list_eula_acceptances",
        op_kwargs={"eulaIds": eula_ids, "nextToken": next_token, "studioId": studio_id},
    )
