"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    global_network_id: str,
    transit_gateway_arns: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the transit gateway registrations in a specified global network.

    Args:
        global_network_id(str): The ID of the global network.
        transit_gateway_arns(List, optional): The Amazon Resource Names (ARNs) of one or more transit gateways. The maximum is 10. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.transit_gateway.registration.get_all(
                ctx, global_network_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.transit_gateway.registration.get_all global_network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="get_transit_gateway_registrations",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "TransitGatewayArns": transit_gateway_arns,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
