"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(
    hub, ctx, global_network_id: str, transit_gateway_arn: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or modify any of its attachments. This action removes any customer gateway associations.

    Args:
        global_network_id(str): The ID of the global network.
        transit_gateway_arn(str): The Amazon Resource Name (ARN) of the transit gateway.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.transit_gateway.init.deregister(
                ctx, global_network_id=value, transit_gateway_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.transit_gateway.init.deregister global_network_id=value, transit_gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="deregister_transit_gateway",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "TransitGatewayArn": transit_gateway_arn,
        },
    )


async def register(hub, ctx, global_network_id: str, transit_gateway_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Registers a transit gateway in your global network. The transit gateway can be in any AWS Region, but it must be owned by the same AWS account that owns the global network. You cannot register a transit gateway in more than one global network.

    Args:
        global_network_id(str): The ID of the global network.
        transit_gateway_arn(str): The Amazon Resource Name (ARN) of the transit gateway. For more information, see Resources Defined by Amazon EC2.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.transit_gateway.init.register(
                ctx, global_network_id=value, transit_gateway_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.transit_gateway.init.register global_network_id=value, transit_gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="register_transit_gateway",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "TransitGatewayArn": transit_gateway_arn,
        },
    )
