"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    global_network_id: str,
    transit_gateway_connect_peer_arn: str,
    device_id: str,
    link_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it must be associated with the specified device.  You can only associate transit gateway Connect peers that have been created on a transit gateway that's registered in your global network. You cannot associate a transit gateway Connect peer with more than one device and link.

    Args:
        global_network_id(str): The ID of the global network.
        transit_gateway_connect_peer_arn(str): The Amazon Resource Name (ARN) of the Connect peer.
        device_id(str): The ID of the device.
        link_id(str, optional): The ID of the link. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.transit_gateway.connect_peer.init.associate(
                ctx,
                global_network_id=value,
                transit_gateway_connect_peer_arn=value,
                device_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.transit_gateway.connect_peer.init.associate global_network_id=value, transit_gateway_connect_peer_arn=value, device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="associate_transit_gateway_connect_peer",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "TransitGatewayConnectPeerArn": transit_gateway_connect_peer_arn,
            "DeviceId": device_id,
            "LinkId": link_id,
        },
    )


async def disassociate(
    hub, ctx, global_network_id: str, transit_gateway_connect_peer_arn: str
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a transit gateway Connect peer from a device and link.

    Args:
        global_network_id(str): The ID of the global network.
        transit_gateway_connect_peer_arn(str): The Amazon Resource Name (ARN) of the transit gateway Connect peer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.transit_gateway.connect_peer.init.disassociate(
                ctx, global_network_id=value, transit_gateway_connect_peer_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.transit_gateway.connect_peer.init.disassociate global_network_id=value, transit_gateway_connect_peer_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="disassociate_transit_gateway_connect_peer",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "TransitGatewayConnectPeerArn": transit_gateway_connect_peer_arn,
        },
    )
