"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    global_network_id: str,
    description: str = None,
    location: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new site in a global network.

    Args:
        global_network_id(str): The ID of the global network.
        description(str, optional): A description of your site. Length Constraints: Maximum length of 256 characters. Defaults to None.
        location(Dict, optional): The site location. This information is used for visualization in the Network Manager console. If you specify the address, the latitude and longitude are automatically calculated.    Address: The physical address of the site.    Latitude: The latitude of the site.     Longitude: The longitude of the site.  . Defaults to None.
        tags(List, optional): The tags to apply to the resource during creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.site.create(ctx, global_network_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.site.create global_network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="create_site",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "Description": description,
            "Location": location,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, global_network_id: str, site_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing site. The site cannot be associated with any device or link.

    Args:
        global_network_id(str): The ID of the global network.
        site_id(str): The ID of the site.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.site.delete(
                ctx, global_network_id=value, site_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.site.delete global_network_id=value, site_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="delete_site",
        op_kwargs={"GlobalNetworkId": global_network_id, "SiteId": site_id},
    )


async def get_all(
    hub,
    ctx,
    global_network_id: str,
    site_ids: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more of your sites in a global network.

    Args:
        global_network_id(str): The ID of the global network.
        site_ids(List, optional): One or more site IDs. The maximum is 10. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.site.get_all(ctx, global_network_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.site.get_all global_network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="get_sites",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "SiteIds": site_ids,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    global_network_id: str,
    site_id: str,
    description: str = None,
    location: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.

    Args:
        global_network_id(str): The ID of the global network.
        site_id(str): The ID of your site.
        description(str, optional): A description of your site. Length Constraints: Maximum length of 256 characters. Defaults to None.
        location(Dict, optional): The site location:    Address: The physical address of the site.    Latitude: The latitude of the site.     Longitude: The longitude of the site.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.site.update(
                ctx, global_network_id=value, site_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.site.update global_network_id=value, site_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="update_site",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "SiteId": site_id,
            "Description": description,
            "Location": location,
        },
    )
