"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub, ctx, global_network_id: str, device_id: str, link_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a link to a device. A device can be associated to multiple links and a link can be associated to multiple devices. The device and link must be in the same global network and the same site.

    Args:
        global_network_id(str): The ID of the global network.
        device_id(str): The ID of the device.
        link_id(str): The ID of the link.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.link.init.associate(
                ctx, global_network_id=value, device_id=value, link_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.link.init.associate global_network_id=value, device_id=value, link_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="associate_link",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "DeviceId": device_id,
            "LinkId": link_id,
        },
    )


async def create(
    hub,
    ctx,
    global_network_id: str,
    bandwidth: Dict,
    site_id: str,
    description: str = None,
    type_: str = None,
    provider: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new link for a specified site.

    Args:
        global_network_id(str): The ID of the global network.
        description(str, optional): A description of the link. Length Constraints: Maximum length of 256 characters. Defaults to None.
        type_(str, optional): The type of the link. Constraints: Cannot include the following characters: | \ ^ Length Constraints: Maximum length of 128 characters. Defaults to None.
        bandwidth(Dict):  The upload speed and download speed in Mbps. .
        provider(str, optional): The provider of the link. Constraints: Cannot include the following characters: | \ ^ Length Constraints: Maximum length of 128 characters. Defaults to None.
        site_id(str): The ID of the site.
        tags(List, optional): The tags to apply to the resource during creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.link.init.create(
                ctx, global_network_id=value, bandwidth=value, site_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.link.init.create global_network_id=value, bandwidth=value, site_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="create_link",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "Description": description,
            "Type": type_,
            "Bandwidth": bandwidth,
            "Provider": provider,
            "SiteId": site_id,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, global_network_id: str, link_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing link. You must first disassociate the link from any devices and customer gateways.

    Args:
        global_network_id(str): The ID of the global network.
        link_id(str): The ID of the link.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.link.init.delete(
                ctx, global_network_id=value, link_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.link.init.delete global_network_id=value, link_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="delete_link",
        op_kwargs={"GlobalNetworkId": global_network_id, "LinkId": link_id},
    )


async def disassociate(
    hub, ctx, global_network_id: str, device_id: str, link_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates an existing device from a link. You must first disassociate any customer gateways that are associated with the link.

    Args:
        global_network_id(str): The ID of the global network.
        device_id(str): The ID of the device.
        link_id(str): The ID of the link.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.link.init.disassociate(
                ctx, global_network_id=value, device_id=value, link_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.link.init.disassociate global_network_id=value, device_id=value, link_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="disassociate_link",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "DeviceId": device_id,
            "LinkId": link_id,
        },
    )


async def get_all(
    hub,
    ctx,
    global_network_id: str,
    link_ids: List = None,
    site_id: str = None,
    type_: str = None,
    provider: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more links in a specified global network. If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type and provider in the same request.

    Args:
        global_network_id(str): The ID of the global network.
        link_ids(List, optional): One or more link IDs. The maximum is 10. Defaults to None.
        site_id(str, optional): The ID of the site. Defaults to None.
        type_(str, optional): The link type. Defaults to None.
        provider(str, optional): The link provider. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.link.init.get_all(ctx, global_network_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.link.init.get_all global_network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="get_links",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "LinkIds": link_ids,
            "SiteId": site_id,
            "Type": type_,
            "Provider": provider,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    global_network_id: str,
    link_id: str,
    description: str = None,
    type_: str = None,
    bandwidth: Dict = None,
    provider: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the details for an existing link. To remove information for any of the parameters, specify an empty string.

    Args:
        global_network_id(str): The ID of the global network.
        link_id(str): The ID of the link.
        description(str, optional): A description of the link. Length Constraints: Maximum length of 256 characters. Defaults to None.
        type_(str, optional): The type of the link. Length Constraints: Maximum length of 128 characters. Defaults to None.
        bandwidth(Dict, optional): The upload and download speed in Mbps. . Defaults to None.
        provider(str, optional): The provider of the link. Length Constraints: Maximum length of 128 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.link.init.update(
                ctx, global_network_id=value, link_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.link.init.update global_network_id=value, link_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="update_link",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "LinkId": link_id,
            "Description": description,
            "Type": type_,
            "Bandwidth": bandwidth,
            "Provider": provider,
        },
    )
