"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    global_network_id: str,
    device_id: str = None,
    link_id: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.

    Args:
        global_network_id(str): The ID of the global network.
        device_id(str, optional): The ID of the device. Defaults to None.
        link_id(str, optional): The ID of the link. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.link.association.get_all(
                ctx, global_network_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.link.association.get_all global_network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="get_link_associations",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "DeviceId": device_id,
            "LinkId": link_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
