"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, description: str = None, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new, empty global network.

    Args:
        description(str, optional): A description of the global network. Length Constraints: Maximum length of 256 characters. Defaults to None.
        tags(List, optional): The tags to apply to the resource during creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.global_network.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.global_network.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="create_global_network",
        op_kwargs={"Description": description, "Tags": tags},
    )


async def delete(hub, ctx, global_network_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing global network. You must first delete all global network objects (devices, links, and sites) and deregister all transit gateways.

    Args:
        global_network_id(str): The ID of the global network.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.global_network.delete(
                ctx, global_network_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.global_network.delete global_network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="delete_global_network",
        op_kwargs={"GlobalNetworkId": global_network_id},
    )


async def describe_all(
    hub,
    ctx,
    global_network_ids: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more global networks. By default, all global networks are described. To describe the objects in your global network, you must use the appropriate Get* action. For example, to list the transit gateways in your global network, use GetTransitGatewayRegistrations.

    Args:
        global_network_ids(List, optional): The IDs of one or more global networks. The maximum is 10. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.global_network.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.global_network.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="describe_global_networks",
        op_kwargs={
            "GlobalNetworkIds": global_network_ids,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(hub, ctx, global_network_id: str, description: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing global network. To remove information for any of the parameters, specify an empty string.

    Args:
        global_network_id(str): The ID of your global network.
        description(str, optional): A description of the global network. Length Constraints: Maximum length of 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.global_network.update(
                ctx, global_network_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.global_network.update global_network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="update_global_network",
        op_kwargs={"GlobalNetworkId": global_network_id, "Description": description},
    )
