"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    global_network_id: str,
    aws_location: Dict = None,
    description: str = None,
    type_: str = None,
    vendor: str = None,
    model: str = None,
    serial_number: str = None,
    location: Dict = None,
    site_id: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.

    Args:
        global_network_id(str): The ID of the global network.
        aws_location(Dict, optional): The AWS location of the device. Defaults to None.
        description(str, optional): A description of the device. Length Constraints: Maximum length of 256 characters. Defaults to None.
        type_(str, optional): The type of the device. Defaults to None.
        vendor(str, optional): The vendor of the device. Length Constraints: Maximum length of 128 characters. Defaults to None.
        model(str, optional): The model of the device. Length Constraints: Maximum length of 128 characters. Defaults to None.
        serial_number(str, optional): The serial number of the device. Length Constraints: Maximum length of 128 characters. Defaults to None.
        location(Dict, optional): The location of the device. Defaults to None.
        site_id(str, optional): The ID of the site. Defaults to None.
        tags(List, optional): The tags to apply to the resource during creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.device.create(ctx, global_network_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.device.create global_network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="create_device",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "AWSLocation": aws_location,
            "Description": description,
            "Type": type_,
            "Vendor": vendor,
            "Model": model,
            "SerialNumber": serial_number,
            "Location": location,
            "SiteId": site_id,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, global_network_id: str, device_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing device. You must first disassociate the device from any links and customer gateways.

    Args:
        global_network_id(str): The ID of the global network.
        device_id(str): The ID of the device.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.device.delete(
                ctx, global_network_id=value, device_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.device.delete global_network_id=value, device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="delete_device",
        op_kwargs={"GlobalNetworkId": global_network_id, "DeviceId": device_id},
    )


async def get_all(
    hub,
    ctx,
    global_network_id: str,
    device_ids: List = None,
    site_id: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more of your devices in a global network.

    Args:
        global_network_id(str): The ID of the global network.
        device_ids(List, optional): One or more device IDs. The maximum is 10. Defaults to None.
        site_id(str, optional): The ID of the site. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.device.get_all(ctx, global_network_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.device.get_all global_network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="get_devices",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "DeviceIds": device_ids,
            "SiteId": site_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    global_network_id: str,
    device_id: str,
    aws_location: Dict = None,
    description: str = None,
    type_: str = None,
    vendor: str = None,
    model: str = None,
    serial_number: str = None,
    location: Dict = None,
    site_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.

    Args:
        global_network_id(str): The ID of the global network.
        device_id(str): The ID of the device.
        aws_location(Dict, optional): The AWS location of the device. Defaults to None.
        description(str, optional): A description of the device. Length Constraints: Maximum length of 256 characters. Defaults to None.
        type_(str, optional): The type of the device. Defaults to None.
        vendor(str, optional): The vendor of the device. Length Constraints: Maximum length of 128 characters. Defaults to None.
        model(str, optional): The model of the device. Length Constraints: Maximum length of 128 characters. Defaults to None.
        serial_number(str, optional): The serial number of the device. Length Constraints: Maximum length of 128 characters. Defaults to None.
        location(Dict, optional): Describes a location. Defaults to None.
        site_id(str, optional): The ID of the site. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.device.update(
                ctx, global_network_id=value, device_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.device.update global_network_id=value, device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="update_device",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "DeviceId": device_id,
            "AWSLocation": aws_location,
            "Description": description,
            "Type": type_,
            "Vendor": vendor,
            "Model": model,
            "SerialNumber": serial_number,
            "Location": location,
            "SiteId": site_id,
        },
    )
