"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    global_network_id: str,
    device_id: str,
    connected_device_id: str,
    link_id: str = None,
    connected_link_id: str = None,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an on-premises network.

    Args:
        global_network_id(str): The ID of the global network.
        device_id(str): The ID of the first device in the connection.
        connected_device_id(str): The ID of the second device in the connection.
        link_id(str, optional): The ID of the link for the first device. Defaults to None.
        connected_link_id(str, optional): The ID of the link for the second device. Defaults to None.
        description(str, optional): A description of the connection. Length Constraints: Maximum length of 256 characters. Defaults to None.
        tags(List, optional): The tags to apply to the resource during creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.connection.create(
                ctx, global_network_id=value, device_id=value, connected_device_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.connection.create global_network_id=value, device_id=value, connected_device_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="create_connection",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "DeviceId": device_id,
            "ConnectedDeviceId": connected_device_id,
            "LinkId": link_id,
            "ConnectedLinkId": connected_link_id,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, global_network_id: str, connection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified connection in your global network.

    Args:
        global_network_id(str): The ID of the global network.
        connection_id(str): The ID of the connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.connection.delete(
                ctx, global_network_id=value, connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.connection.delete global_network_id=value, connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="delete_connection",
        op_kwargs={"GlobalNetworkId": global_network_id, "ConnectionId": connection_id},
    )


async def get_all(
    hub,
    ctx,
    global_network_id: str,
    connection_ids: List = None,
    device_id: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more of your connections in a global network.

    Args:
        global_network_id(str): The ID of the global network.
        connection_ids(List, optional): One or more connection IDs. Defaults to None.
        device_id(str, optional): The ID of the device. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.connection.get_all(ctx, global_network_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.connection.get_all global_network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="get_connections",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "ConnectionIds": connection_ids,
            "DeviceId": device_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    global_network_id: str,
    connection_id: str,
    link_id: str = None,
    connected_link_id: str = None,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the information for an existing connection. To remove information for any of the parameters, specify an empty string.

    Args:
        global_network_id(str): The ID of the global network.
        connection_id(str): The ID of the connection.
        link_id(str, optional): The ID of the link for the first device in the connection. Defaults to None.
        connected_link_id(str, optional): The ID of the link for the second device in the connection. Defaults to None.
        description(str, optional): A description of the connection. Length Constraints: Maximum length of 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.networkmanager.connection.update(
                ctx, global_network_id=value, connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.networkmanager.connection.update global_network_id=value, connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="networkmanager",
        operation="update_connection",
        op_kwargs={
            "GlobalNetworkId": global_network_id,
            "ConnectionId": connection_id,
            "LinkId": link_id,
            "ConnectedLinkId": connected_link_id,
            "Description": description,
        },
    )
