"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    subnet_mappings: List,
    update_token: str = None,
    firewall_arn: str = None,
    firewall_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the Availability Zones that the VPC spans.  This request creates an AWS Network Firewall firewall endpoint in each of the subnets. To enable the firewall's protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the traffic that's coming into and going out of the zone through the firewall endpoint.

    Args:
        update_token(str, optional): An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request.  To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it. To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an InvalidTokenException. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. . Defaults to None.
        firewall_arn(str, optional): The Amazon Resource Name (ARN) of the firewall. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_name(str, optional): The descriptive name of the firewall. You can't change the name of a firewall after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        subnet_mappings(List): The IDs of the subnets that you want to associate with the firewall. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.subnet.init.associate(
                ctx, subnet_mappings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.subnet.init.associate subnet_mappings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="associate_subnets",
        op_kwargs={
            "UpdateToken": update_token,
            "FirewallArn": firewall_arn,
            "FirewallName": firewall_name,
            "SubnetMappings": subnet_mappings,
        },
    )


async def disassociate(
    hub,
    ctx,
    subnet_ids: List,
    update_token: str = None,
    firewall_arn: str = None,
    firewall_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets and removes any network filtering protections that the endpoints were providing.

    Args:
        update_token(str, optional): An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request.  To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it. To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an InvalidTokenException. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. . Defaults to None.
        firewall_arn(str, optional): The Amazon Resource Name (ARN) of the firewall. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_name(str, optional): The descriptive name of the firewall. You can't change the name of a firewall after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        subnet_ids(List): The unique identifiers for the subnets that you want to disassociate. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.subnet.init.disassociate(ctx, subnet_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.subnet.init.disassociate subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="disassociate_subnets",
        op_kwargs={
            "UpdateToken": update_token,
            "FirewallArn": firewall_arn,
            "FirewallName": firewall_name,
            "SubnetIds": subnet_ids,
        },
    )
