"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    rule_group_name: str,
    type_: str,
    capacity: int,
    rule_group: Dict = None,
    rules: str = None,
    description: str = None,
    tags: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection, a capacity setting, and tags.  You provide your rule group specification in your request using either RuleGroup or Rules.

    Args:
        rule_group_name(str): The descriptive name of the rule group. You can't change the name of a rule group after you create it.
        rule_group(Dict, optional): An object that defines the rule group rules.   You must provide either this rule group setting or a Rules setting, but not both.  . Defaults to None.
        rules(str, optional): A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups.   You must provide either this rules setting or a populated RuleGroup setting, but not both.   You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a RuleGroup object that Network Firewall has populated from your string. . Defaults to None.
        type_(str): Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules. .
        description(str, optional): A description of the rule group. . Defaults to None.
        capacity(int): The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group.  You can retrieve the capacity that would be required for a rule group before you create the rule group by calling CreateRuleGroup with DryRun set to TRUE.   You can't change or exceed this capacity when you update the rule group, so leave room for your rule group to grow.    Capacity for a stateless rule group  For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules that you expect to have in the rule group.  To calculate the capacity requirement of a single rule, multiply the capacity requirement values of each of the rule's match settings:   A match setting with no criteria specified has a value of 1.    A match setting with Any specified has a value of 1.    All other match settings have a value equal to the number of elements provided in the setting. For example, a protocol setting ["UDP"] and a source setting ["10.0.0.0/24"] each have a value of 1. A protocol setting ["UDP","TCP"] has a value of 2. A source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of 3.    A rule with no criteria specified in any of its match settings has a capacity requirement of 1. A rule with protocol setting ["UDP","TCP"], source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a single specification or no specification for each of the other match settings has a capacity requirement of 6.   Capacity for a stateful rule group  For a stateful rule group, the minimum capacity required is the number of individual rules that you expect to have in the rule group. .
        tags(List, optional): The key:value pairs to associate with the resource. Defaults to None.
        dry_run(bool, optional): Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.  If set to TRUE, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to FALSE, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.  If set to FALSE, Network Firewall makes the requested changes to your resources. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.rule_group.create(
                ctx, rule_group_name=value, type_=value, capacity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.rule_group.create rule_group_name=value, type_=value, capacity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="create_rule_group",
        op_kwargs={
            "RuleGroupName": rule_group_name,
            "RuleGroup": rule_group,
            "Rules": rules,
            "Type": type_,
            "Description": description,
            "Capacity": capacity,
            "Tags": tags,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub, ctx, rule_group_name: str = None, rule_group_arn: str = None, type_: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified RuleGroup.

    Args:
        rule_group_name(str, optional): The descriptive name of the rule group. You can't change the name of a rule group after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        rule_group_arn(str, optional): The Amazon Resource Name (ARN) of the rule group. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        type_(str, optional): Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.   This setting is required for requests that do not include the RuleGroupARN. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.rule_group.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.rule_group.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="delete_rule_group",
        op_kwargs={
            "RuleGroupName": rule_group_name,
            "RuleGroupArn": rule_group_arn,
            "Type": type_,
        },
    )


async def describe(
    hub, ctx, rule_group_name: str = None, rule_group_arn: str = None, type_: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the data objects for the specified rule group.

    Args:
        rule_group_name(str, optional): The descriptive name of the rule group. You can't change the name of a rule group after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        rule_group_arn(str, optional): The Amazon Resource Name (ARN) of the rule group. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        type_(str, optional): Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.   This setting is required for requests that do not include the RuleGroupARN. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.rule_group.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.rule_group.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="describe_rule_group",
        op_kwargs={
            "RuleGroupName": rule_group_name,
            "RuleGroupArn": rule_group_arn,
            "Type": type_,
        },
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and the number of rule groups, a single call might not return the full list.

    Args:
        next_token(str, optional): When you request a list of objects with a MaxResults setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a NextToken value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request. Defaults to None.
        max_results(int, optional): The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a NextToken value that you can use in a subsequent call to get the next batch of objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.rule_group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.rule_group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="list_rule_groups",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub,
    ctx,
    update_token: str,
    rule_group_arn: str = None,
    rule_group_name: str = None,
    rule_group: Dict = None,
    rules: str = None,
    type_: str = None,
    description: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall policies. When you modify a rule group, you modify all firewall policies that use the rule group.  To update a rule group, first call DescribeRuleGroup to retrieve the current RuleGroup object, update the object as needed, and then provide the updated object to this call.

    Args:
        update_token(str): A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request.  To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an InvalidTokenException. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token. .
        rule_group_arn(str, optional): The Amazon Resource Name (ARN) of the rule group. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        rule_group_name(str, optional): The descriptive name of the rule group. You can't change the name of a rule group after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        rule_group(Dict, optional): An object that defines the rule group rules.   You must provide either this rule group setting or a Rules setting, but not both.  . Defaults to None.
        rules(str, optional): A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups.   You must provide either this rules setting or a populated RuleGroup setting, but not both.   You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a RuleGroup object that Network Firewall has populated from your string. . Defaults to None.
        type_(str, optional): Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.   This setting is required for requests that do not include the RuleGroupARN. . Defaults to None.
        description(str, optional): A description of the rule group. . Defaults to None.
        dry_run(bool, optional): Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.  If set to TRUE, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to FALSE, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.  If set to FALSE, Network Firewall makes the requested changes to your resources. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.rule_group.update(ctx, update_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.rule_group.update update_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="update_rule_group",
        op_kwargs={
            "UpdateToken": update_token,
            "RuleGroupArn": rule_group_arn,
            "RuleGroupName": rule_group_name,
            "RuleGroup": rule_group,
            "Rules": rules,
            "Type": type_,
            "Description": description,
            "DryRun": dry_run,
        },
    )
