"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a resource policy that you created in a PutResourcePolicy request.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to delete. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.resource.policy.delete(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.resource.policy.delete resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="delete_resource_policy",
        op_kwargs={"ResourceArn": resource_arn},
    )


async def describe(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a resource policy that you created in a PutResourcePolicy request.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the rule group or firewall policy whose resource policy you want to retrieve. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.resource.policy.describe(
                ctx, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.resource.policy.describe resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="describe_resource_policy",
        op_kwargs={"ResourceArn": resource_arn},
    )


async def put(hub, ctx, resource_arn: str, policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates an AWS Identity and Access Management policy for your rule group or firewall policy. Use this to share rule groups and firewall policies between accounts. This operation works in conjunction with the AWS Resource Access Manager (RAM) service to manage resource sharing for Network Firewall.  Use this operation to create or update a resource policy for your rule group or firewall policy. In the policy, you specify the accounts that you want to share the resource with and the operations that you want the accounts to be able to perform.  When you add an account in the resource policy, you then run the following Resource Access Manager (RAM) operations to access and accept the shared rule group or firewall policy.     GetResourceShareInvitations - Returns the Amazon Resource Names (ARNs) of the resource share invitations.     AcceptResourceShareInvitation - Accepts the share invitation for a specified resource share.    For additional information about resource sharing using RAM, see AWS Resource Access Manager User Guide.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the account that you want to share rule groups and firewall policies with.
        policy(str): The AWS Identity and Access Management policy statement that lists the accounts that you want to share your rule group or firewall policy with and the operations that you want the accounts to be able to perform.  For a rule group resource, you can specify the following operations in the Actions section of the statement:   network-firewall:CreateFirewallPolicy   network-firewall:UpdateFirewallPolicy   network-firewall:ListRuleGroups   For a firewall policy resource, you can specify the following operations in the Actions section of the statement:   network-firewall:CreateFirewall   network-firewall:UpdateFirewall   network-firewall:AssociateFirewallPolicy   network-firewall:ListFirewallPolicies   In the Resource section of the statement, you specify the ARNs for the rule groups and firewall policies that you want to share with the account that you specified in Arn.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.resource.policy.put(
                ctx, resource_arn=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.resource.policy.put resource_arn=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="put_resource_policy",
        op_kwargs={"ResourceArn": resource_arn, "Policy": policy},
    )
