"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, firewall_arn: str = None, firewall_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the logging configuration for the specified firewall.

    Args:
        firewall_arn(str, optional): The Amazon Resource Name (ARN) of the firewall. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_name(str, optional): The descriptive name of the firewall. You can't change the name of a firewall after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.logging_configuration.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.logging_configuration.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="describe_logging_configuration",
        op_kwargs={"FirewallArn": firewall_arn, "FirewallName": firewall_name},
    )


async def update(
    hub,
    ctx,
    firewall_arn: str = None,
    firewall_name: str = None,
    logging_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the logging configuration for the specified firewall.  To change the logging configuration, retrieve the LoggingConfiguration by calling DescribeLoggingConfiguration, then change it and provide the modified object to this update call. You must change the logging configuration one LogDestinationConfig at a time inside the retrieved LoggingConfiguration object.  You can perform only one of the following actions in any call to UpdateLoggingConfiguration:    Create a new log destination object by adding a single LogDestinationConfig array element to LogDestinationConfigs.   Delete a log destination object by removing a single LogDestinationConfig array element from LogDestinationConfigs.   Change the LogDestination setting in a single LogDestinationConfig array element.   You can't change the LogDestinationType or LogType in a LogDestinationConfig. To change these settings, delete the existing LogDestinationConfig object and create a new one, using two separate calls to this update operation.

    Args:
        firewall_arn(str, optional): The Amazon Resource Name (ARN) of the firewall. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_name(str, optional): The descriptive name of the firewall. You can't change the name of a firewall after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        logging_configuration(Dict, optional): Defines how Network Firewall performs logging for a firewall. If you omit this setting, Network Firewall disables logging for the firewall. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.logging_configuration.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.logging_configuration.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="update_logging_configuration",
        op_kwargs={
            "FirewallArn": firewall_arn,
            "FirewallName": firewall_name,
            "LoggingConfiguration": logging_configuration,
        },
    )
