"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    firewall_policy_arn: str,
    update_token: str = None,
    firewall_arn: str = None,
    firewall_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a FirewallPolicy to a Firewall.  A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.

    Args:
        update_token(str, optional): An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request.  To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it. To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an InvalidTokenException. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. . Defaults to None.
        firewall_arn(str, optional): The Amazon Resource Name (ARN) of the firewall. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_name(str, optional): The descriptive name of the firewall. You can't change the name of a firewall after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_policy_arn(str): The Amazon Resource Name (ARN) of the firewall policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.firewall.policy.init.associate(
                ctx, firewall_policy_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.firewall.policy.init.associate firewall_policy_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="associate_firewall_policy",
        op_kwargs={
            "UpdateToken": update_token,
            "FirewallArn": firewall_arn,
            "FirewallName": firewall_name,
            "FirewallPolicyArn": firewall_policy_arn,
        },
    )


async def create(
    hub,
    ctx,
    firewall_policy_name: str,
    firewall_policy: Dict,
    description: str = None,
    tags: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates the firewall policy for the firewall according to the specifications.  An AWS Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful rule groups and other settings. You can use one firewall policy for multiple firewalls.

    Args:
        firewall_policy_name(str): The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
        firewall_policy(Dict): The rule groups and policy actions to use in the firewall policy.
        description(str, optional): A description of the firewall policy. Defaults to None.
        tags(List, optional): The key:value pairs to associate with the resource. Defaults to None.
        dry_run(bool, optional): Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.  If set to TRUE, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to FALSE, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.  If set to FALSE, Network Firewall makes the requested changes to your resources. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.firewall.policy.init.create(
                ctx, firewall_policy_name=value, firewall_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.firewall.policy.init.create firewall_policy_name=value, firewall_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="create_firewall_policy",
        op_kwargs={
            "FirewallPolicyName": firewall_policy_name,
            "FirewallPolicy": firewall_policy,
            "Description": description,
            "Tags": tags,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub, ctx, firewall_policy_name: str = None, firewall_policy_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified FirewallPolicy.

    Args:
        firewall_policy_name(str, optional): The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_policy_arn(str, optional): The Amazon Resource Name (ARN) of the firewall policy. You must specify the ARN or the name, and you can specify both. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.firewall.policy.init.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.firewall.policy.init.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="delete_firewall_policy",
        op_kwargs={
            "FirewallPolicyName": firewall_policy_name,
            "FirewallPolicyArn": firewall_policy_arn,
        },
    )


async def describe(
    hub, ctx, firewall_policy_name: str = None, firewall_policy_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the data objects for the specified firewall policy.

    Args:
        firewall_policy_name(str, optional): The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_policy_arn(str, optional): The Amazon Resource Name (ARN) of the firewall policy. You must specify the ARN or the name, and you can specify both. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.firewall.policy.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.firewall.policy.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="describe_firewall_policy",
        op_kwargs={
            "FirewallPolicyName": firewall_policy_name,
            "FirewallPolicyArn": firewall_policy_arn,
        },
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results and the number of firewall policies, a single call might not return the full list.

    Args:
        next_token(str, optional): When you request a list of objects with a MaxResults setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a NextToken value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request. Defaults to None.
        max_results(int, optional): The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a NextToken value that you can use in a subsequent call to get the next batch of objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.firewall.policy.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.firewall.policy.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="list_firewall_policies",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub,
    ctx,
    update_token: str,
    firewall_policy: Dict,
    firewall_policy_arn: str = None,
    firewall_policy_name: str = None,
    description: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the properties of the specified firewall policy.

    Args:
        update_token(str): A token used for optimistic locking. Network Firewall returns a token to your requests that access the firewall policy. The token marks the state of the policy resource at the time of the request.  To make changes to the policy, you provide the token in your request. Network Firewall uses the token to ensure that the policy hasn't changed since you last retrieved it. If it has changed, the operation fails with an InvalidTokenException. If this happens, retrieve the firewall policy again to get a current copy of it with current token. Reapply your changes as needed, then try the operation again using the new token. .
        firewall_policy_arn(str, optional): The Amazon Resource Name (ARN) of the firewall policy. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_policy_name(str, optional): The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_policy(Dict): The updated firewall policy to use for the firewall. .
        description(str, optional): A description of the firewall policy. Defaults to None.
        dry_run(bool, optional): Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.  If set to TRUE, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to FALSE, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.  If set to FALSE, Network Firewall makes the requested changes to your resources. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.firewall.policy.init.update(
                ctx, update_token=value, firewall_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.firewall.policy.init.update update_token=value, firewall_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="update_firewall_policy",
        op_kwargs={
            "UpdateToken": update_token,
            "FirewallPolicyArn": firewall_policy_arn,
            "FirewallPolicyName": firewall_policy_name,
            "FirewallPolicy": firewall_policy,
            "Description": description,
            "DryRun": dry_run,
        },
    )
