"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    firewall_policy_change_protection: bool,
    update_token: str = None,
    firewall_arn: str = None,
    firewall_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        update_token(str, optional): An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request.  To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it. To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an InvalidTokenException. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token. . Defaults to None.
        firewall_arn(str, optional): The Amazon Resource Name (ARN) of the firewall. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_name(str, optional): The descriptive name of the firewall. You can't change the name of a firewall after you create it. You must specify the ARN or the name, and you can specify both. . Defaults to None.
        firewall_policy_change_protection(bool): A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to TRUE.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.network_firewall.firewall.policy.change_protection.update(
                ctx, firewall_policy_change_protection=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.network_firewall.firewall.policy.change_protection.update firewall_policy_change_protection=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="network-firewall",
        operation="update_firewall_policy_change_protection",
        op_kwargs={
            "UpdateToken": update_token,
            "FirewallArn": firewall_arn,
            "FirewallName": firewall_name,
            "FirewallPolicyChangeProtection": firewall_policy_change_protection,
        },
    )
