"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def add(hub, ctx, resource_name: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon Neptune resources, or used in a Condition statement in an IAM policy for Amazon Neptune.

    Args:
        resource_name(str): The Amazon Neptune resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see  Constructing an Amazon Resource Name (ARN).
        tags(List): The tags to be assigned to the Amazon Neptune resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.tags.to_resource.add(
                ctx, resource_name=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.tags.to_resource.add resource_name=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="add_tags_to_resource",
        op_kwargs={"ResourceName": resource_name, "Tags": tags},
    )
