"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, resource_name: str, filters: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all tags on an Amazon Neptune resource.

    Args:
        resource_name(str): The Amazon Neptune resource with tags to be listed. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see  Constructing an Amazon Resource Name (ARN).
        filters(List, optional): This parameter is not currently supported. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.tags.for_resource.list(ctx, resource_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.tags.for_resource.list resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="list_tags_for_resource",
        op_kwargs={"ResourceName": resource_name, "Filters": filters},
    )
