"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def remove(hub, ctx, subscription_name: str, source_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a source identifier from an existing event notification subscription.

    Args:
        subscription_name(str): The name of the event notification subscription you want to remove a source identifier from.
        source_identifier(str):  The source identifier to be removed from the subscription, such as the DB instance identifier for a DB instance or the name of a security group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.source_identifier.from_subscription.remove(
                ctx, subscription_name=value, source_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.source_identifier.from_subscription.remove subscription_name=value, source_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="remove_source_identifier_from_subscription",
        op_kwargs={
            "SubscriptionName": subscription_name,
            "SourceIdentifier": source_identifier,
        },
    )
