"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def remove(
    hub, ctx, db_cluster_identifier: str, role_arn: str, feature_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Disassociates an Identity and Access Management (IAM) role from a DB cluster.

    Args:
        db_cluster_identifier(str): The name of the DB cluster to disassociate the IAM role from.
        role_arn(str): The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB cluster, for example arn:aws:iam::123456789012:role/NeptuneAccessRole.
        feature_name(str, optional): The name of the feature for the DB cluster that the IAM role is to be disassociated from. For the list of supported feature names, see DBEngineVersion. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.role.from_db_cluster.remove(
                ctx, db_cluster_identifier=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.role.from_db_cluster.remove db_cluster_identifier=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="remove_role_from_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "RoleArn": role_arn,
            "FeatureName": feature_name,
        },
    )
