"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    db_parameter_group_family: str,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the default engine and system parameter information for the specified database engine.

    Args:
        db_parameter_group_family(str): The name of the DB parameter group family.
        filters(List, optional): Not currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous DescribeEngineDefaultParameters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.engine_default.parameter.describe_all(
                ctx, db_parameter_group_family=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.engine_default.parameter.describe_all db_parameter_group_family=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="describe_engine_default_parameters",
        op_kwargs={
            "DBParameterGroupFamily": db_parameter_group_family,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
