"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    db_instance_identifier: str,
    db_instance_class: str,
    engine: str,
    db_name: str = None,
    allocated_storage: int = None,
    master_username: str = None,
    master_user_password: str = None,
    db_security_groups: List = None,
    vpc_security_group_ids: List = None,
    availability_zone: str = None,
    db_subnet_group_name: str = None,
    preferred_maintenance_window: str = None,
    db_parameter_group_name: str = None,
    backup_retention_period: int = None,
    preferred_backup_window: str = None,
    port: int = None,
    multi_az: bool = None,
    engine_version: str = None,
    auto_minor_version_upgrade: bool = None,
    license_model: str = None,
    iops: int = None,
    option_group_name: str = None,
    character_set_name: str = None,
    publicly_accessible: bool = None,
    tags: List = None,
    db_cluster_identifier: str = None,
    storage_type: str = None,
    tde_credential_arn: str = None,
    tde_credential_password: str = None,
    storage_encrypted: bool = None,
    kms_key_id: str = None,
    domain: str = None,
    copy_tags_to_snapshot: bool = None,
    monitoring_interval: int = None,
    monitoring_role_arn: str = None,
    domain_iam_role_name: str = None,
    promotion_tier: int = None,
    timezone: str = None,
    enable_iam_database_authentication: bool = None,
    enable_performance_insights: bool = None,
    performance_insights_kms_key_id: str = None,
    enable_cloudwatch_logs_exports: List = None,
    deletion_protection: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new DB instance.

    Args:
        db_name(str, optional): Not supported. Defaults to None.
        db_instance_identifier(str): The DB instance identifier. This parameter is stored as a lowercase string. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.   First character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.   Example: mydbinstance .
        allocated_storage(int, optional): Not supported by Neptune. Defaults to None.
        db_instance_class(str): The compute and memory capacity of the DB instance, for example, db.m4.large. Not all DB instance classes are available in all Amazon Regions.
        engine(str): The name of the database engine to be used for this instance. Valid Values: neptune .
        master_username(str, optional): Not supported by Neptune. Defaults to None.
        master_user_password(str, optional): Not supported by Neptune. Defaults to None.
        db_security_groups(List, optional): A list of DB security groups to associate with this DB instance. Default: The default DB security group for the database engine. Defaults to None.
        vpc_security_group_ids(List, optional): A list of EC2 VPC security groups to associate with this DB instance. Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see CreateDBCluster. Default: The default EC2 VPC security group for the DB subnet group's VPC. Defaults to None.
        availability_zone(str, optional):  The EC2 Availability Zone that the DB instance is created in Default: A random, system-chosen Availability Zone in the endpoint's Amazon Region.  Example: us-east-1d   Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ parameter is set to true. The specified Availability Zone must be in the same Amazon Region as the current endpoint. Defaults to None.
        db_subnet_group_name(str, optional): A DB subnet group to associate with this DB instance. If there is no DB subnet group, then it is a non-VPC DB instance. Defaults to None.
        preferred_maintenance_window(str, optional): The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).  Format: ddd:hh24:mi-ddd:hh24:mi  The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week. Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun. Constraints: Minimum 30-minute window. Defaults to None.
        db_parameter_group_name(str, optional): The name of the DB parameter group to associate with this DB instance. If this argument is omitted, the default DBParameterGroup for the specified engine is used. Constraints:   Must be 1 to 255 letters, numbers, or hyphens.   First character must be a letter   Cannot end with a hyphen or contain two consecutive hyphens  . Defaults to None.
        backup_retention_period(int, optional): The number of days for which automated backups are retained. Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see CreateDBCluster. Default: 1 Constraints:   Must be a value from 0 to 35   Cannot be set to 0 if the DB instance is a source to Read Replicas  . Defaults to None.
        preferred_backup_window(str, optional):  The daily time range during which automated backups are created. Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see CreateDBCluster. Defaults to None.
        port(int, optional): The port number on which the database accepts connections. Not applicable. The port is managed by the DB cluster. For more information, see CreateDBCluster.  Default: 8182  Type: Integer. Defaults to None.
        multi_az(bool, optional): Specifies if the DB instance is a Multi-AZ deployment. You can't set the AvailabilityZone parameter if the MultiAZ parameter is set to true. Defaults to None.
        engine_version(str, optional): The version number of the database engine to use. Currently, setting this parameter has no effect. Defaults to None.
        auto_minor_version_upgrade(bool, optional): Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window. Default: true . Defaults to None.
        license_model(str, optional): License model information for this DB instance.  Valid values: license-included | bring-your-own-license | general-public-license . Defaults to None.
        iops(int, optional): The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance. Defaults to None.
        option_group_name(str, optional):  (Not supported by Neptune) . Defaults to None.
        character_set_name(str, optional):  (Not supported by Neptune) . Defaults to None.
        publicly_accessible(bool, optional): This flag should no longer be used. Defaults to None.
        tags(List, optional): The tags to assign to the new instance. Defaults to None.
        db_cluster_identifier(str, optional): The identifier of the DB cluster that the instance will belong to. For information on creating a DB cluster, see CreateDBCluster. Type: String. Defaults to None.
        storage_type(str, optional): Specifies the storage type to be associated with the DB instance. Not applicable. Storage is managed by the DB Cluster. Defaults to None.
        tde_credential_arn(str, optional): The ARN from the key store with which to associate the instance for TDE encryption. Defaults to None.
        tde_credential_password(str, optional): The password for the given ARN from the key store in order to access the device. Defaults to None.
        storage_encrypted(bool, optional): Specifies whether the DB instance is encrypted. Not applicable. The encryption for DB instances is managed by the DB cluster. For more information, see CreateDBCluster. Default: false. Defaults to None.
        kms_key_id(str, optional): The Amazon KMS key identifier for an encrypted DB instance. The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB instance with the same Amazon account that owns the KMS encryption key used to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the KM encryption key. Not applicable. The KMS key identifier is managed by the DB cluster. For more information, see CreateDBCluster. If the StorageEncrypted parameter is true, and you do not specify a value for the KmsKeyId parameter, then Amazon Neptune will use your default encryption key. Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region. Defaults to None.
        domain(str, optional): Specify the Active Directory Domain to create the instance in. Defaults to None.
        copy_tags_to_snapshot(bool, optional): True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false. Defaults to None.
        monitoring_interval(int, optional): The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. If MonitoringRoleArn is specified, then you must also set MonitoringInterval to a value other than 0. Valid Values: 0, 1, 5, 10, 15, 30, 60 . Defaults to None.
        monitoring_role_arn(str, optional): The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess. If MonitoringInterval is set to a value other than 0, then you must supply a MonitoringRoleArn value. Defaults to None.
        domain_iam_role_name(str, optional): Specify the name of the IAM role to be used when making API calls to the Directory Service. Defaults to None.
        promotion_tier(int, optional): A value that specifies the order in which an Read Replica is promoted to the primary instance after a failure of the existing primary instance.  Default: 1 Valid Values: 0 - 15. Defaults to None.
        timezone(str, optional): The time zone of the DB instance. Defaults to None.
        enable_iam_database_authentication(bool, optional): Not supported by Neptune (ignored). Defaults to None.
        enable_performance_insights(bool, optional):  (Not supported by Neptune) . Defaults to None.
        performance_insights_kms_key_id(str, optional):  (Not supported by Neptune) . Defaults to None.
        enable_cloudwatch_logs_exports(List, optional): The list of log types that need to be enabled for exporting to CloudWatch Logs. Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See Deleting a DB Instance. DB instances in a DB cluster can be deleted even when deletion protection is enabled in their parent DB cluster. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.instance.create(
                ctx, db_instance_identifier=value, db_instance_class=value, engine=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.instance.create db_instance_identifier=value, db_instance_class=value, engine=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="create_db_instance",
        op_kwargs={
            "DBName": db_name,
            "DBInstanceIdentifier": db_instance_identifier,
            "AllocatedStorage": allocated_storage,
            "DBInstanceClass": db_instance_class,
            "Engine": engine,
            "MasterUsername": master_username,
            "MasterUserPassword": master_user_password,
            "DBSecurityGroups": db_security_groups,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "AvailabilityZone": availability_zone,
            "DBSubnetGroupName": db_subnet_group_name,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "DBParameterGroupName": db_parameter_group_name,
            "BackupRetentionPeriod": backup_retention_period,
            "PreferredBackupWindow": preferred_backup_window,
            "Port": port,
            "MultiAZ": multi_az,
            "EngineVersion": engine_version,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "LicenseModel": license_model,
            "Iops": iops,
            "OptionGroupName": option_group_name,
            "CharacterSetName": character_set_name,
            "PubliclyAccessible": publicly_accessible,
            "Tags": tags,
            "DBClusterIdentifier": db_cluster_identifier,
            "StorageType": storage_type,
            "TdeCredentialArn": tde_credential_arn,
            "TdeCredentialPassword": tde_credential_password,
            "StorageEncrypted": storage_encrypted,
            "KmsKeyId": kms_key_id,
            "Domain": domain,
            "CopyTagsToSnapshot": copy_tags_to_snapshot,
            "MonitoringInterval": monitoring_interval,
            "MonitoringRoleArn": monitoring_role_arn,
            "DomainIAMRoleName": domain_iam_role_name,
            "PromotionTier": promotion_tier,
            "Timezone": timezone,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "EnablePerformanceInsights": enable_performance_insights,
            "PerformanceInsightsKMSKeyId": performance_insights_kms_key_id,
            "EnableCloudwatchLogsExports": enable_cloudwatch_logs_exports,
            "DeletionProtection": deletion_protection,
        },
    )


async def delete(
    hub,
    ctx,
    db_instance_identifier: str,
    skip_final_snapshot: bool = None,
    final_db_snapshot_identifier: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to be deleted by DeleteDBInstance are not deleted.  If you request a final DB snapshot the status of the Amazon Neptune DB instance is deleting until the DB snapshot is created. The API action DescribeDBInstance is used to monitor the status of this operation. The action can't be canceled or reverted once submitted. Note that when a DB instance is in a failure state and has a status of failed, incompatible-restore, or incompatible-network, you can only delete it when the SkipFinalSnapshot parameter is set to true. You can't delete a DB instance if it is the only instance in the DB cluster, or if it has deletion protection enabled.

    Args:
        db_instance_identifier(str): The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive. Constraints:   Must match the name of an existing DB instance.  .
        skip_final_snapshot(bool, optional):  Determines whether a final DB snapshot is created before the DB instance is deleted. If true is specified, no DBSnapshot is created. If false is specified, a DB snapshot is created before the DB instance is deleted. Note that when a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore', or 'incompatible-network', it can only be deleted when the SkipFinalSnapshot parameter is set to "true". Specify true when deleting a Read Replica.  The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is false.  Default: false . Defaults to None.
        final_db_snapshot_identifier(str, optional):  The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to false.  Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.  Constraints:   Must be 1 to 255 letters or numbers.   First character must be a letter   Cannot end with a hyphen or contain two consecutive hyphens   Cannot be specified when deleting a Read Replica.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.instance.delete(ctx, db_instance_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.instance.delete db_instance_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="delete_db_instance",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "SkipFinalSnapshot": skip_final_snapshot,
            "FinalDBSnapshotIdentifier": final_db_snapshot_identifier,
        },
    )


async def describe_all(
    hub,
    ctx,
    db_instance_identifier: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about provisioned instances, and supports pagination.  This operation can also return information for Amazon RDS instances and Amazon DocDB instances.

    Args:
        db_instance_identifier(str, optional): The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive. Constraints:   If supplied, must match the identifier of an existing DBInstance.  . Defaults to None.
        filters(List, optional): A filter that specifies one or more DB instances to describe. Supported filters:    db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB instances associated with the DB clusters identified by these ARNs.    engine - Accepts an engine name (such as neptune), and restricts the results list to DB instances created by that engine.   For example, to invoke this API from the Amazon CLI and filter so that only Neptune DB instances are returned, you could use the following command:. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous DescribeDBInstances request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.instance.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.instance.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="describe_db_instances",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(
    hub,
    ctx,
    db_instance_identifier: str,
    allocated_storage: int = None,
    db_instance_class: str = None,
    db_subnet_group_name: str = None,
    db_security_groups: List = None,
    vpc_security_group_ids: List = None,
    apply_immediately: bool = None,
    master_user_password: str = None,
    db_parameter_group_name: str = None,
    backup_retention_period: int = None,
    preferred_backup_window: str = None,
    preferred_maintenance_window: str = None,
    multi_az: bool = None,
    engine_version: str = None,
    allow_major_version_upgrade: bool = None,
    auto_minor_version_upgrade: bool = None,
    license_model: str = None,
    iops: int = None,
    option_group_name: str = None,
    new_db_instance_identifier: str = None,
    storage_type: str = None,
    tde_credential_arn: str = None,
    tde_credential_password: str = None,
    ca_certificate_identifier: str = None,
    domain: str = None,
    copy_tags_to_snapshot: bool = None,
    monitoring_interval: int = None,
    db_port_number: int = None,
    publicly_accessible: bool = None,
    monitoring_role_arn: str = None,
    domain_iam_role_name: str = None,
    promotion_tier: int = None,
    enable_iam_database_authentication: bool = None,
    enable_performance_insights: bool = None,
    performance_insights_kms_key_id: str = None,
    cloudwatch_logs_export_configuration: Dict = None,
    deletion_protection: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. To learn what modifications you can make to your DB instance, call DescribeValidDBInstanceModifications before you call ModifyDBInstance.

    Args:
        db_instance_identifier(str): The DB instance identifier. This value is stored as a lowercase string. Constraints:   Must match the identifier of an existing DBInstance.  .
        allocated_storage(int, optional): Not supported by Neptune. Defaults to None.
        db_instance_class(str, optional): The new compute and memory capacity of the DB instance, for example, db.m4.large. Not all DB instance classes are available in all AWS Regions. If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless ApplyImmediately is specified as true for this request. Default: Uses existing setting. Defaults to None.
        db_subnet_group_name(str, optional): The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC. Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you specify true for the ApplyImmediately parameter. Constraints: If supplied, must match the name of an existing DBSubnetGroup. Example: mySubnetGroup . Defaults to None.
        db_security_groups(List, optional): A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage and the change is asynchronously applied as soon as possible. Constraints:   If supplied, must match existing DBSecurityGroups.  . Defaults to None.
        vpc_security_group_ids(List, optional): A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon as possible. Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see ModifyDBCluster. Constraints:   If supplied, must match existing VpcSecurityGroupIds.  . Defaults to None.
        apply_immediately(bool, optional): Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the PreferredMaintenanceWindow setting for the DB instance.  If this parameter is set to false, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to RebootDBInstance, or the next failure reboot. Default: false . Defaults to None.
        master_user_password(str, optional): Not supported by Neptune. Defaults to None.
        db_parameter_group_name(str, optional): The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. The db instance will NOT be rebooted automatically and the parameter changes will NOT be applied during the next maintenance window. Default: Uses existing setting Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance. Defaults to None.
        backup_retention_period(int, optional): Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see ModifyDBCluster. Default: Uses existing setting. Defaults to None.
        preferred_backup_window(str, optional):  The daily time range during which automated backups are created if automated backups are enabled. Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see ModifyDBCluster. Constraints:   Must be in the format hh24:mi-hh24:mi   Must be in Universal Time Coordinated (UTC)   Must not conflict with the preferred maintenance window   Must be at least 30 minutes  . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter will cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied. Default: Uses existing setting Format: ddd:hh24:mi-ddd:hh24:mi Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun Constraints: Must be at least 30 minutes. Defaults to None.
        multi_az(bool, optional): Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage and the change is applied during the next maintenance window unless the ApplyImmediately parameter is set to true for this request. Defaults to None.
        engine_version(str, optional): The version number of the database engine to upgrade to. Currently, setting this parameter has no effect. To upgrade your database engine to the most recent release, use the ApplyPendingMaintenanceAction API. Defaults to None.
        allow_major_version_upgrade(bool, optional): Indicates that major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible. Defaults to None.
        auto_minor_version_upgrade(bool, optional):  Indicates that minor version upgrades are applied automatically to the DB instance during the maintenance window. Changing this parameter doesn't result in an outage except in the following case and the change is asynchronously applied as soon as possible. An outage will result if this parameter is set to true during the maintenance window, and a newer minor version is available, and Neptune has enabled auto patching for that engine version. Defaults to None.
        license_model(str, optional): Not supported by Neptune. Defaults to None.
        iops(int, optional): The new Provisioned IOPS (I/O operations per second) value for the instance. Changing this setting doesn't result in an outage and the change is applied during the next maintenance window unless the ApplyImmediately parameter is set to true for this request. Default: Uses existing setting. Defaults to None.
        option_group_name(str, optional):  (Not supported by Neptune) . Defaults to None.
        new_db_instance_identifier(str, optional):  The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot will occur immediately if you set Apply Immediately to true, or will occur during the next maintenance window if Apply Immediately to false. This value is stored as a lowercase string. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.   The first character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.   Example: mydbinstance . Defaults to None.
        storage_type(str, optional): Not supported. Defaults to None.
        tde_credential_arn(str, optional): The ARN from the key store with which to associate the instance for TDE encryption. Defaults to None.
        tde_credential_password(str, optional): The password for the given ARN from the key store in order to access the device. Defaults to None.
        ca_certificate_identifier(str, optional): Indicates the certificate that needs to be associated with the instance. Defaults to None.
        domain(str, optional): Not supported. Defaults to None.
        copy_tags_to_snapshot(bool, optional): True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false. Defaults to None.
        monitoring_interval(int, optional): The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. If MonitoringRoleArn is specified, then you must also set MonitoringInterval to a value other than 0. Valid Values: 0, 1, 5, 10, 15, 30, 60 . Defaults to None.
        db_port_number(int, optional): The port number on which the database accepts connections. The value of the DBPortNumber parameter must not match any of the port values specified for options in the option group for the DB instance. Your database will restart when you change the DBPortNumber value regardless of the value of the ApplyImmediately parameter.  Default: 8182 . Defaults to None.
        publicly_accessible(bool, optional): This flag should no longer be used. Defaults to None.
        monitoring_role_arn(str, optional): The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess. If MonitoringInterval is set to a value other than 0, then you must supply a MonitoringRoleArn value. Defaults to None.
        domain_iam_role_name(str, optional): Not supported. Defaults to None.
        promotion_tier(int, optional): A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of the existing primary instance. Default: 1 Valid Values: 0 - 15. Defaults to None.
        enable_iam_database_authentication(bool, optional): True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false. You can enable IAM database authentication for the following database engines Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB cluster. For more information, see ModifyDBCluster. Default: false . Defaults to None.
        enable_performance_insights(bool, optional):  (Not supported by Neptune) . Defaults to None.
        performance_insights_kms_key_id(str, optional):  (Not supported by Neptune) . Defaults to None.
        cloudwatch_logs_export_configuration(Dict, optional): The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster. Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See Deleting a DB Instance. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.instance.modify(ctx, db_instance_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.instance.modify db_instance_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="modify_db_instance",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "AllocatedStorage": allocated_storage,
            "DBInstanceClass": db_instance_class,
            "DBSubnetGroupName": db_subnet_group_name,
            "DBSecurityGroups": db_security_groups,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "ApplyImmediately": apply_immediately,
            "MasterUserPassword": master_user_password,
            "DBParameterGroupName": db_parameter_group_name,
            "BackupRetentionPeriod": backup_retention_period,
            "PreferredBackupWindow": preferred_backup_window,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "MultiAZ": multi_az,
            "EngineVersion": engine_version,
            "AllowMajorVersionUpgrade": allow_major_version_upgrade,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "LicenseModel": license_model,
            "Iops": iops,
            "OptionGroupName": option_group_name,
            "NewDBInstanceIdentifier": new_db_instance_identifier,
            "StorageType": storage_type,
            "TdeCredentialArn": tde_credential_arn,
            "TdeCredentialPassword": tde_credential_password,
            "CACertificateIdentifier": ca_certificate_identifier,
            "Domain": domain,
            "CopyTagsToSnapshot": copy_tags_to_snapshot,
            "MonitoringInterval": monitoring_interval,
            "DBPortNumber": db_port_number,
            "PubliclyAccessible": publicly_accessible,
            "MonitoringRoleArn": monitoring_role_arn,
            "DomainIAMRoleName": domain_iam_role_name,
            "PromotionTier": promotion_tier,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "EnablePerformanceInsights": enable_performance_insights,
            "PerformanceInsightsKMSKeyId": performance_insights_kms_key_id,
            "CloudwatchLogsExportConfiguration": cloudwatch_logs_export_configuration,
            "DeletionProtection": deletion_protection,
        },
    )


async def reboot(
    hub, ctx, db_instance_identifier: str, force_failover: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the instance for the changes to take effect. Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary outage, during which the DB instance status is set to rebooting.

    Args:
        db_instance_identifier(str): The DB instance identifier. This parameter is stored as a lowercase string. Constraints:   Must match the identifier of an existing DBInstance.  .
        force_failover(bool, optional):  When true, the reboot is conducted through a MultiAZ failover. Constraint: You can't specify true if the instance is not configured for MultiAZ. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.instance.reboot(ctx, db_instance_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.instance.reboot db_instance_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="reboot_db_instance",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "ForceFailover": force_failover,
        },
    )
