"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def restore(
    hub,
    ctx,
    db_cluster_identifier: str,
    source_db_cluster_identifier: str,
    restore_type: str = None,
    restore_to_time: str = None,
    use_latest_restorable_time: bool = None,
    port: int = None,
    db_subnet_group_name: str = None,
    option_group_name: str = None,
    vpc_security_group_ids: List = None,
    tags: List = None,
    kms_key_id: str = None,
    enable_iam_database_authentication: bool = None,
    enable_cloudwatch_logs_exports: List = None,
    db_cluster_parameter_group_name: str = None,
    deletion_protection: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before LatestRestorableTime for up to BackupRetentionPeriod days. The target DB cluster is created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB cluster is created with the default DB security group.  This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the CreateDBInstance action to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in DBClusterIdentifier. You can create DB instances only after the RestoreDBClusterToPointInTime action has completed and the DB cluster is available.

    Args:
        db_cluster_identifier(str): The name of the new DB cluster to be created. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens   First character must be a letter   Cannot end with a hyphen or contain two consecutive hyphens  .
        restore_type(str, optional): The type of restore to be performed. You can specify one of the following values:    full-copy - The new DB cluster is restored as a full copy of the source DB cluster.    copy-on-write - The new DB cluster is restored as a clone of the source DB cluster.   If you don't specify a RestoreType value, then the new DB cluster is restored as a full copy of the source DB cluster. Defaults to None.
        source_db_cluster_identifier(str): The identifier of the source DB cluster from which to restore. Constraints:   Must match the identifier of an existing DBCluster.  .
        restore_to_time(str, optional): The date and time to restore the DB cluster to. Valid Values: Value must be a time in Universal Coordinated Time (UTC) format Constraints:   Must be before the latest restorable time for the DB instance   Must be specified if UseLatestRestorableTime parameter is not provided   Cannot be specified if UseLatestRestorableTime parameter is true   Cannot be specified if RestoreType parameter is copy-on-write    Example: 2015-03-07T23:45:00Z . Defaults to None.
        use_latest_restorable_time(bool, optional): A value that is set to true to restore the DB cluster to the latest restorable backup time, and false otherwise. Default: false  Constraints: Cannot be specified if RestoreToTime parameter is provided. Defaults to None.
        port(int, optional): The port number on which the new DB cluster accepts connections. Constraints: Value must be 1150-65535  Default: The same port as the original DB cluster. Defaults to None.
        db_subnet_group_name(str, optional): The DB subnet group name to use for the new DB cluster. Constraints: If supplied, must match the name of an existing DBSubnetGroup. Example: mySubnetgroup . Defaults to None.
        option_group_name(str, optional):  (Not supported by Neptune) . Defaults to None.
        vpc_security_group_ids(List, optional): A list of VPC security groups that the new DB cluster belongs to. Defaults to None.
        tags(List, optional): The tags to be applied to the restored DB cluster. Defaults to None.
        kms_key_id(str, optional): The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster. The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key. You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different than the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the KmsKeyId parameter. If you do not specify a value for the KmsKeyId parameter, then the following will occur:   If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.   If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.   If DBClusterIdentifier refers to a DB cluster that is not encrypted, then the restore request is rejected. Defaults to None.
        enable_iam_database_authentication(bool, optional): True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false. Default: false . Defaults to None.
        enable_cloudwatch_logs_exports(List, optional): The list of logs that the restored DB cluster is to export to CloudWatch Logs. Defaults to None.
        db_cluster_parameter_group_name(str, optional): The name of the DB cluster parameter group to associate with the new DB cluster. Constraints:   If supplied, must match the name of an existing DBClusterParameterGroup.  . Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.neptune.db.cluster.to_point_in_time.restore(
                ctx, db_cluster_identifier=value, source_db_cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.neptune.db.cluster.to_point_in_time.restore db_cluster_identifier=value, source_db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="neptune",
        operation="restore_db_cluster_to_point_in_time",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "RestoreType": restore_type,
            "SourceDBClusterIdentifier": source_db_cluster_identifier,
            "RestoreToTime": restore_to_time,
            "UseLatestRestorableTime": use_latest_restorable_time,
            "Port": port,
            "DBSubnetGroupName": db_subnet_group_name,
            "OptionGroupName": option_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "Tags": tags,
            "KmsKeyId": kms_key_id,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "EnableCloudwatchLogsExports": enable_cloudwatch_logs_exports,
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "DeletionProtection": deletion_protection,
        },
    )
